/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.linksource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.aksw.jenax.arq.util.exec.query.QueryExecTransform;
import org.aksw.jenax.arq.util.query.QueryTransform;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.update.UpdateRequestTransform;
import org.aksw.jenax.dataaccess.deleted.RDFLinkSourceWrapperWithSparqlStmtTransform;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderWrapperBaseParse;
import org.aksw.jenax.dataaccess.sparql.builder.exec.update.UpdateExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecSelect;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecWrapperBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.ExprTransformPrettyMacroExpansion;
import org.aksw.jenax.dataaccess.sparql.link.common.RDFLinkUtils;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryQueryTransform;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryTransform;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryTransformPaginate;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryWrapperBase;
import org.aksw.jenax.dataaccess.sparql.link.transform.RDFLinkTransform;
import org.aksw.jenax.dataaccess.sparql.link.update.LinkSparqlUpdateTransform;
import org.aksw.jenax.dataaccess.sparql.link.update.LinkSparqlUpdateUpdateTransform;
import org.aksw.jenax.dataaccess.sparql.linksource.DecoratedRDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceDecorator;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceOverDatasetGraph;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceWrapperBase;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceWrapperWithLinkTransform;
import org.aksw.jenax.model.udf.util.UserDefinedFunctions;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.aksw.jenax.stmt.core.SparqlStmtTransform;
import org.aksw.jenax.stmt.core.SparqlStmtTransformViaRewrite;
import org.aksw.jenax.stmt.core.SparqlStmtTransforms;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.LinkSparqlUpdate;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFLinkSources {
    private static final Logger logger = LoggerFactory.getLogger(RDFLinkSources.class);

    public static RDFLinkSource of(Graph graph) {
        DatasetGraph dsg = DatasetGraphFactory.wrap((Graph)graph);
        return RDFLinkSources.of(dsg);
    }

    public static RDFLinkSource of(DatasetGraph datasetGraph) {
        return new RDFLinkSourceOverDatasetGraph(datasetGraph);
    }

    public static QueryExecBuilder newQueryBuilder(final RDFLinkSource linkSource) {
        QueryExecBuilderCustomBase<QueryExecBuilder> queryExecBuilder = new QueryExecBuilderCustomBase<QueryExecBuilder>(){

            @Override
            public QueryExec build() {
                final RDFLink link = linkSource.newLink();
                QueryExecBuilder delegateBuilder = link.newQuery();
                this.applySettings(delegateBuilder);
                QueryExec delegateExec = delegateBuilder.build();
                return new QueryExecWrapperBase<QueryExec>(delegateExec){

                    @Override
                    public void close() {
                        try {
                            super.close();
                        }
                        finally {
                            link.close();
                        }
                    }
                };
            }
        };
        return queryExecBuilder;
    }

    public static UpdateExecBuilder newUpdateBuilder(final RDFLinkSource linkSource) {
        UpdateExecBuilderCustomBase<UpdateExecBuilder> updateExecBuilder = new UpdateExecBuilderCustomBase<UpdateExecBuilder>(){

            public UpdateExec build() {
                final Context cxt = this.getContext();
                return new UpdateExec(){
                    protected volatile UpdateExec delegate = null;
                    protected volatile boolean isAborted = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void abort() {
                        if (!this.isAborted) {
                            UpdateExec current = null;
                            boolean doAbort = false;
                            1 var3_3 = this;
                            synchronized (var3_3) {
                                if (!this.isAborted) {
                                    this.isAborted = true;
                                    doAbort = true;
                                    current = this.delegate;
                                }
                            }
                            if (doAbort && current != null) {
                                current.abort();
                            }
                        }
                    }

                    public Context getContext() {
                        return cxt;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute() {
                        try (RDFLink link = null;){
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                if (this.isAborted) {
                                    throw new QueryCancelledException();
                                }
                                if (this.delegate != null) {
                                    throw new RuntimeException("Execution already started.");
                                }
                                link = linkSource.newLink();
                                UpdateExecBuilder delegateBuilder = link.newUpdate();
                                this.applySettings(delegateBuilder);
                                this.delegate = delegateBuilder.build();
                            }
                            this.delegate.execute();
                        }
                    }
                };
            }
        };
        return updateExecBuilder;
    }

    public static RDFLinkSource wrapWithLogging(RDFLinkSource delegate) {
        return new RDFLinkSourceWrapperBase<RDFLinkSource>(delegate){
            protected AtomicInteger counter = new AtomicInteger();

            @Override
            public RDFLink newLink() {
                RDFLink base = super.newLink();
                return RDFLinkUtils.wrapWithQueryTransform(base, null, qe -> new QueryExecWrapperBase<QueryExec>(qe){

                    @Override
                    public void beforeExec() {
                        int value = counter.incrementAndGet();
                        if (logger.isInfoEnabled()) {
                            logger.info("{}: Request #{}: {}", new Object[]{Thread.currentThread().getName(), value, this.getDelegate().getQueryString()});
                        }
                    }
                });
            }
        };
    }

    public static RDFLinkSource decorateQueryBeforeTxnBegin(RDFLinkSource linkSource, final Runnable action) {
        LinkSparqlQueryTransform componentTransform = link -> new LinkSparqlQueryWrapperBase((LinkSparqlQuery)link){

            @Override
            public void begin(TxnType type) {
                action.run();
                super.begin(type);
            }

            @Override
            public void begin(ReadWrite readWrite) {
                this.begin(TxnType.convert((ReadWrite)readWrite));
            }
        };
        RDFLinkSource result = RDFLinkSources.wrapWithLinkTransform(linkSource, link -> RDFLinkUtils.apply(link, componentTransform));
        return result;
    }

    public static RDFLinkSource execQueryViaSelect(RDFLinkSource linkSource, Predicate<Query> convertToSelect) {
        LinkSparqlQueryTransform decorizer = RDFLinkSources.execQueryViaSelect(convertToSelect);
        DecoratedRDFLinkSource result = RDFLinkSourceDecorator.of(linkSource).decorate(decorizer).build();
        return result;
    }

    public static LinkSparqlQueryTransform execQueryViaSelect(Predicate<Query> convertToSelect) {
        LinkSparqlQueryTransform result = baseLink -> new LinkSparqlQueryWrapperBase((LinkSparqlQuery)baseLink, (LinkSparqlQuery)baseLink, convertToSelect){
            final /* synthetic */ LinkSparqlQuery val$baseLink;
            final /* synthetic */ Predicate val$convertToSelect;
            {
                this.val$baseLink = linkSparqlQuery;
                this.val$convertToSelect = predicate;
                super(delegate);
            }

            @Override
            public QueryExecBuilder newQuery() {
                return new QueryExecBuilderWrapperBaseParse(this.val$baseLink.newQuery()){
                    protected Query seenQuery;
                    {
                        super(delegate);
                        this.seenQuery = null;
                    }

                    @Override
                    public QueryExecBuilder query(Query query) {
                        this.seenQuery = query;
                        return this;
                    }

                    @Override
                    public QueryExec build() {
                        Objects.requireNonNull(this.seenQuery, "Query not set");
                        boolean doConvert = val$convertToSelect.test(this.seenQuery);
                        QueryExec r = doConvert ? QueryExecSelect.of(this.seenQuery, q -> this.delegate.query(q).build()) : this.getDelegate().query(this.seenQuery).build();
                        return r;
                    }
                };
            }
        };
        return result;
    }

    public static RDFLinkSource wrapWithAutoTxn(RDFLinkSource linkSource, Dataset dataset) {
        RDFLinkSource result = dataset.supportsTransactions() ? RDFLinkSources.wrapWithLinkTransform(linkSource, link -> RDFLinkUtils.wrapWithAutoTxn(link, (Transactional)dataset)) : linkSource;
        return result;
    }

    public static RDFLinkSource wrapWithOpTransform(RDFLinkSource dataSource, Rewrite rewrite) {
        return RDFLinkSourceDecorator.of(dataSource).decorate(op -> rewrite.rewrite(op)).build();
    }

    public static RDFLinkSource wrapWithLinkTransform(RDFLinkSource linkSource, RDFLinkTransform transform) {
        return new RDFLinkSourceWrapperWithLinkTransform<RDFLinkSource>(linkSource, transform);
    }

    public static RDFLinkSource wrapWithStmtTransform(RDFLinkSource linkSource, SparqlStmtTransform stmtTransform) {
        RDFLinkSource result;
        if (stmtTransform instanceof SparqlStmtTransformViaRewrite) {
            Rewrite rewrite = ((SparqlStmtTransformViaRewrite)stmtTransform).getRewrite();
            result = RDFLinkSources.wrapWithOpTransform(linkSource, rewrite);
        } else {
            result = new RDFLinkSourceWrapperWithSparqlStmtTransform<RDFLinkSource>(linkSource, stmtTransform);
        }
        return result;
    }

    public static RDFLinkSource wrapWithOpTransform(RDFLinkSource dataSource, Transform statelessTransform) {
        SparqlStmtTransform stmtTransform = SparqlStmtTransforms.of((Transform)statelessTransform);
        return RDFLinkSources.wrapWithStmtTransform(dataSource, stmtTransform);
    }

    public static RDFLinkSource wrapWithLinkSparqlQueryTransform(RDFLinkSource linkSource, LinkSparqlQueryTransform transform) {
        return RDFLinkSources.wrapWithLinkTransform(linkSource, link -> RDFLinkUtils.wrapWithQueryLinkTransform(link, transform));
    }

    public static RDFLinkSource wrapWithLinkSparqlUpdateTransform(RDFLinkSource linkSource, LinkSparqlUpdateTransform transform) {
        return RDFLinkSources.wrapWithLinkTransform(linkSource, link -> RDFLinkUtils.wrapWithUpdateLinkTransform(link, transform));
    }

    public static RDFLinkSource wrapWithOpTransform(RDFLinkSource dataSource, Supplier<Transform> transformSupplier) {
        SparqlStmtTransform stmtTransform = SparqlStmtTransforms.of(transformSupplier);
        return RDFLinkSources.wrapWithStmtTransform(dataSource, stmtTransform);
    }

    public static Map<String, UserDefinedFunctionDefinition> loadMacros(String macroSource) {
        LinkedHashMap<String, UserDefinedFunctionDefinition> udfRegistry = new LinkedHashMap<String, UserDefinedFunctionDefinition>();
        RDFLinkSources.loadMacros(Set.of(), udfRegistry, macroSource);
        return udfRegistry;
    }

    public static void loadMacros(Set<String> macroProfiles, Map<String, UserDefinedFunctionDefinition> udfRegistry, String macroSource) {
        Model model = RDFDataMgr.loadModel((String)macroSource);
        SparqlStmtMgr.execSparql((Model)model, (String)"udf-inferences.rq");
        Map contrib = UserDefinedFunctions.load((Model)model, macroProfiles);
        udfRegistry.putAll(contrib);
    }

    public static RDFLinkSource wrapWithMacros(RDFLinkSource linkSource, Map<String, UserDefinedFunctionDefinition> udfRegistry) {
        ExprTransformPrettyMacroExpansion eform = new ExprTransformPrettyMacroExpansion(udfRegistry);
        RDFLinkSource result = RDFLinkSources.wrapWithExprTransform(linkSource, (ExprTransform)eform);
        return result;
    }

    public static RDFLinkSource wrapWithExprTransform(RDFLinkSource linkSource, ExprTransform eform) {
        SparqlStmtTransform stmtTransform = SparqlStmtTransforms.ofExprTransform((ExprTransform)eform);
        RDFLinkSource result = RDFLinkSources.wrapWithStmtTransform(linkSource, stmtTransform);
        return result;
    }

    public static RDFLinkSource wrapWithUpdateTransform(RDFLinkSource linkSource, UpdateRequestTransform updateTransform) {
        return RDFLinkSources.wrapWithLinkSparqlUpdateTransform(linkSource, link -> new LinkSparqlUpdateUpdateTransform((LinkSparqlUpdate)link, (Function<? super UpdateRequest, ? extends UpdateRequest>)updateTransform, null));
    }

    public static RDFLinkSource wrapWithQueryTransform(RDFLinkSource linkSource, QueryTransform queryTransform) {
        return RDFLinkSources.wrapWithLinkSparqlQueryTransform(linkSource, link -> new LinkSparqlQueryQueryTransform((LinkSparqlQuery)link, queryTransform, null));
    }

    public static RDFLinkSource wrapWithQueryExecTransform(RDFLinkSource linkSource, QueryExecTransform queryExecTransform) {
        return RDFLinkSources.wrapWithLinkSparqlQueryTransform(linkSource, link -> new LinkSparqlQueryQueryTransform((LinkSparqlQuery)link, null, queryExecTransform));
    }

    public static RDFLinkSource withLimit(RDFLinkSource linkSource, long limit) {
        return limit == Long.MIN_VALUE ? linkSource : RDFLinkSources.wrapWithQueryTransform(linkSource, q -> QueryUtils.restrictToLimit((Query)q, (long)limit, (boolean)true));
    }

    public static RDFLinkSource withPaginate(RDFLinkSource linkSource, long pageSize) {
        return RDFLinkSources.wrapWithLinkSparqlQueryTransform(linkSource, new LinkSparqlQueryTransformPaginate(pageSize));
    }
}

