/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataengine;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.aksw.jenax.dataaccess.sparql.creator.RDFDatabaseFactory;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.Provider;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactory;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryProvider;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RdfDataEngineFactoryProviderSimple;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RdfDataStore;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RdfDatabaseFactoryProvider;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceDecorator;
import org.apache.jena.sys.JenaSystem;

public class RDFEngineFactoryRegistry {
    private static RDFEngineFactoryRegistry INSTANCE;
    protected Map<String, RDFEngineFactoryProvider> engineProviderRegistry = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, RdfDatabaseFactoryProvider> databaseProviderRegistry = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, RdfDataSourceDecorator> decoratorRegistry = Collections.synchronizedMap(new LinkedHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RDFEngineFactoryRegistry get() {
        if (INSTANCE != null) return INSTANCE;
        Class<RDFEngineFactoryRegistry> clazz = RDFEngineFactoryRegistry.class;
        synchronized (RDFEngineFactoryRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new RDFEngineFactoryRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public RDFEngineFactoryRegistry putFactory(String providerAndFactoryName, RDFEngineFactory factory) {
        Objects.requireNonNull(providerAndFactoryName);
        Objects.requireNonNull(factory);
        RdfDataEngineFactoryProviderSimple provider = new RdfDataEngineFactoryProviderSimple(providerAndFactoryName, factory);
        this.putEngineProvider(providerAndFactoryName, provider);
        return this;
    }

    public RDFEngineFactoryRegistry putEngineProvider(String providerName, RDFEngineFactoryProvider provider) {
        Objects.requireNonNull(providerName);
        Objects.requireNonNull(provider);
        this.engineProviderRegistry.put(providerName, provider);
        return this;
    }

    public RDFEngineFactoryRegistry putDatabaseProvider(String providerName, RdfDatabaseFactoryProvider provider) {
        Objects.requireNonNull(providerName);
        Objects.requireNonNull(provider);
        this.databaseProviderRegistry.put(providerName, provider);
        return this;
    }

    public RDFEngineFactoryProvider getProvider(String name) {
        return this.engineProviderRegistry.get(name);
    }

    private static <T> T provide(Map<String, ? extends Provider<? extends T>> providerMap, String name) {
        T result = providerMap.entrySet().stream().flatMap(e -> {
            Provider provider = (Provider)e.getValue();
            Object r = provider.create(name);
            return Stream.ofNullable(r);
        }).findFirst().orElse(null);
        return result;
    }

    public RdfDataStore getStore(String name) {
        RDFEngineFactory engineFactory = this.getEngineFactory(name);
        RDFDatabaseFactory databaseFactory = this.getDatabaseFactory(name);
        return new RdfDataStore(engineFactory, databaseFactory);
    }

    @Deprecated
    public RDFEngineFactory getFactory(String name) {
        return this.getEngineFactory(name);
    }

    public RDFEngineFactory getEngineFactory(String name) {
        RDFEngineFactory result = (RDFEngineFactory)RDFEngineFactoryRegistry.provide(this.engineProviderRegistry, name);
        return result;
    }

    public RDFDatabaseFactory getDatabaseFactory(String name) {
        RDFDatabaseFactory result = (RDFDatabaseFactory)RDFEngineFactoryRegistry.provide(this.databaseProviderRegistry, name);
        return result;
    }

    public RDFEngineFactoryRegistry putDecorator(String name, RdfDataSourceDecorator factory) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(factory);
        this.decoratorRegistry.put(name, factory);
        return this;
    }

    public RdfDataSourceDecorator getDecorator(String name) {
        return this.decoratorRegistry.get(name);
    }

    static {
        JenaSystem.init();
    }
}

