/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.datasource;

import java.util.Objects;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.link.transform.LinkSparqlQueryTransformApp;
import org.aksw.jenax.dataaccess.sparql.link.transform.RDFLinkTransforms;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceAdapter;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.sparql.core.DatasetGraph;

public class RDFDataSourceAdapter
implements RDFDataSource {
    protected RDFLinkSource linkSource;

    protected RDFDataSourceAdapter(RDFLinkSource linkSource) {
        this.linkSource = linkSource;
    }

    @Override
    public Dataset getDataset() {
        DatasetGraph dsg = this.linkSource.getDatasetGraph();
        Dataset ds = dsg == null ? null : DatasetFactory.wrap((DatasetGraph)dsg);
        return ds;
    }

    @Override
    public RDFLinkSource asLinkSource() {
        return this.linkSource;
    }

    @Override
    public RDFConnection getConnection() {
        RDFLink link = this.linkSource.newLink();
        DatasetGraph dsg = this.linkSource.getDatasetGraph();
        RDFConnection result = RDFDataSourceAdapter.adapt(link, dsg);
        return result;
    }

    public static RDFConnection adapt(RDFLink link, DatasetGraph dsg) {
        Objects.requireNonNull(link);
        RDFLink finalLink = dsg == null ? link : (RDFLink)RDFLinkTransforms.of(new LinkSparqlQueryTransformApp(dsg)).apply(link);
        RDFConnection result = RDFConnectionAdapter.adapt((RDFLink)finalLink);
        return result;
    }

    public static RDFDataSource adapt(RDFLinkSource linkSource) {
        RDFDataSource rDFDataSource;
        Objects.requireNonNull(linkSource);
        if (linkSource instanceof RDFLinkSourceAdapter) {
            RDFLinkSourceAdapter adapter = (RDFLinkSourceAdapter)linkSource;
            rDFDataSource = adapter.asDataSource();
        } else {
            rDFDataSource = new RDFDataSourceAdapter(linkSource);
        }
        RDFDataSource result = rDFDataSource;
        return result;
    }
}

