/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Iterator;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SetFromMappedPropertyValues<T>
extends AbstractSet<T> {
    protected Resource subject;
    protected Property property;
    protected boolean isFwd;
    protected NodeMapper<T> nodeMapper;

    public SetFromMappedPropertyValues(Resource subject, Property property, NodeMapper<T> nodeMapper) {
        this(subject, property, true, nodeMapper);
    }

    public SetFromMappedPropertyValues(Resource subject, Property property, boolean isFwd, NodeMapper<T> nodeMapper) {
        this.subject = subject;
        this.property = property;
        this.isFwd = isFwd;
        this.nodeMapper = nodeMapper;
    }

    @Override
    public boolean add(T obj) {
        Node node = (Node)this.nodeMapper.toNode(obj);
        RDFNode rdfNode = this.subject.getModel().asRDFNode(node);
        boolean result = ResourceUtils.addProperty((RDFNode)this.subject, this.property, this.isFwd, rdfNode);
        return result;
    }

    @Override
    public void clear() {
        ResourceUtils.setProperty(this.subject, this.property, this.isFwd, this.nodeMapper, null);
    }

    @Override
    public Iterator<T> iterator() {
        ExtendedIterator<T> result = ResourceUtils.listPropertyValues(this.subject, this.property, this.isFwd, this.nodeMapper);
        return result;
    }

    @Override
    public int size() {
        int result = Iterators.size(this.iterator());
        return result;
    }
}

