/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Objects;
import java.util.function.Function;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class NodeMapperFromRdfDatatype<T>
implements NodeMapper<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected RDFDatatype dtype;

    public NodeMapperFromRdfDatatype(RDFDatatype dtype) {
        this.dtype = dtype;
    }

    @Override
    public boolean canMap(Node node) {
        boolean result = this.dtype != null && NodeMapperFromRdfDatatype.canMapCore(node, this.dtype);
        return result;
    }

    public static boolean canMapCore(Node node, Class<?> clazz) {
        boolean result;
        Class<?> objClass;
        Object obj = node.isLiteral() ? node.getLiteralValue() : null;
        Class<?> clazz2 = objClass = obj == null ? null : obj.getClass();
        if (objClass != null && clazz.isAssignableFrom(objClass)) {
            result = true;
        } else {
            TypeMapper tm = TypeMapper.getInstance();
            RDFDatatype dtype = tm.getTypeByClass(clazz);
            if (dtype == null) {
                result = false;
                if (node.isLiteral()) {
                    dtype = node.getLiteralDatatype();
                    Function<Node, Object> c = NodeMapperFromRdfDatatype.getCoercion(dtype, clazz);
                    result = c != null;
                }
            } else {
                result = NodeMapperFromRdfDatatype.canMapCore(node, dtype);
            }
        }
        return result;
    }

    public static Function<Node, Object> getCoercion(RDFDatatype dtype, Class<?> tgtClazz) {
        Function<Node, Object> result = null;
        Class srcClass = dtype.getJavaClass();
        if (srcClass != null && XSDDateTime.class.isAssignableFrom(srcClass) && Calendar.class.isAssignableFrom(tgtClazz)) {
            result = node -> {
                Object obj = node.getLiteralValue();
                Calendar r = ((XSDDateTime)obj).asCalendar();
                return r;
            };
        }
        return result;
    }

    public static boolean canMapCore(Node node, RDFDatatype dtype) {
        boolean result;
        if (node.isLiteral()) {
            Object value = node.getLiteralValue();
            result = dtype.isValidValue(value);
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public Node toNode(T obj) {
        String lex = this.dtype.unparse(obj);
        Node result = NodeFactory.createLiteral((String)lex, (RDFDatatype)this.dtype);
        return result;
    }

    @Override
    public T toJava(Node node) {
        T result = NodeMapperFromRdfDatatype.toJavaCore(node, this.dtype);
        return result;
    }

    public static <T> T toJavaCore(Node node, Class<?> clazz) {
        Object obj = node.isLiteral() ? node.getLiteralValue() : null;
        Class<?> objClass = obj == null ? null : obj.getClass();
        Object result = null;
        if (objClass != null && clazz.isAssignableFrom(objClass)) {
            result = obj;
        } else {
            TypeMapper tm = TypeMapper.getInstance();
            RDFDatatype dtype = tm.getTypeByClass(clazz);
            if (dtype == null) {
                if (node.isLiteral() && dtype == null && node.isLiteral()) {
                    Object o;
                    dtype = node.getLiteralDatatype();
                    Function<Node, Object> c = NodeMapperFromRdfDatatype.getCoercion(dtype, clazz);
                    result = o = c.apply(node);
                }
                Objects.requireNonNull(dtype, "Expected an RDFDatatype for java class '" + String.valueOf(clazz) + "'");
            } else {
                result = NodeMapperFromRdfDatatype.toJavaCore(node, dtype);
            }
        }
        return (T)result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T toJavaCore(Node node, RDFDatatype dtype) {
        Object obj;
        Class javaClass = dtype.getJavaClass();
        if (Number.class.isAssignableFrom(javaClass)) {
            String lex = node.getLiteralLexicalForm();
            if (javaClass.equals(BigDecimal.class)) {
                obj = new BigDecimal(lex);
                return (T)obj;
            }
            if (javaClass.equals(BigInteger.class)) {
                BigDecimal tmp = new BigDecimal(lex);
                obj = tmp.toBigInteger();
                return (T)obj;
            }
            try {
                Method m;
                try {
                    m = javaClass.getMethod("valueOf", String.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("No 'valueOf' method found on Numeric for parsing " + String.valueOf(node) + " against java type " + String.valueOf(javaClass) + " based on RDF type " + String.valueOf(dtype));
                }
                obj = m.invoke(null, lex);
                return (T)obj;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        obj = node.getLiteralValue();
        return (T)obj;
    }

    @Override
    public Class<?> getJavaClass() {
        Class result = this.dtype.getJavaClass();
        return result;
    }
}

