/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.views.map;

import com.google.common.base.Converter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.commons.collections.sets.SetFromCollection;
import org.aksw.commons.util.convert.ConvertFunction;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.rdf.collections.SetFromPropertyValues;
import org.aksw.jena_sparql_api.utils.views.map.MapFromResourceBase;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntryKv;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntryWithCast;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class MapFromResource
extends MapFromResourceBase<RDFNode, RDFNode> {
    protected final Property entryProperty;
    protected final Property keyProperty;
    protected final Property valueProperty;
    protected BiFunction<Resource, RDFNode, Resource> sAndKeyToEntry;

    public MapFromResource(Resource subject, Property entryProperty, Property keyProperty, Property valueProperty) {
        this(subject, entryProperty, keyProperty, valueProperty, null, null);
    }

    public MapFromResource(Resource subject, Property entryProperty, Property keyProperty, Property valueProperty, ConvertFunction<? super RDFNode, RDFNode> keyConverter, ConvertFunction<? super RDFNode, RDFNode> valueConverter) {
        this(subject, entryProperty, keyProperty, valueProperty, keyConverter, valueConverter, (s, k) -> s.getModel().createResource());
    }

    public MapFromResource(Resource subject, Property entryProperty, Property keyProperty, Property valueProperty, ConvertFunction<? super RDFNode, RDFNode> keyConverter, ConvertFunction<? super RDFNode, RDFNode> valueConverter, BiFunction<Resource, RDFNode, Resource> sAndKeyToEntry) {
        super(subject, keyConverter, valueConverter);
        this.entryProperty = entryProperty;
        this.keyProperty = keyProperty;
        this.valueProperty = valueProperty;
        this.sAndKeyToEntry = sAndKeyToEntry;
    }

    @Override
    public RDFNode get(Object key) {
        Resource entry = key instanceof RDFNode ? this.getEntry((RDFNode)key) : null;
        RDFNode result = entry == null ? null : ResourceUtils.getPropertyValue(entry, this.valueProperty);
        return result;
    }

    public Resource getEntry(RDFNode key) {
        Resource result = this.getEntryViaModel(key);
        return result;
    }

    public Resource getEntryViaModel(RDFNode key) {
        Model model = this.subject.getModel();
        List tmp = model.listSubjectsWithProperty(this.keyProperty, key).filterKeep(e -> model.contains(this.subject, this.entryProperty, (RDFNode)e)).toList();
        Resource result = tmp.isEmpty() ? null : (Resource)tmp.get(0);
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        RDFNode r = this.get(key);
        boolean result = r != null;
        return result;
    }

    @Override
    public Resource put(RDFNode key, RDFNode value) {
        Resource entry = this.getEntry(key);
        if (entry == null) {
            entry = this.sAndKeyToEntry.apply(this.subject, key);
            Objects.requireNonNull(entry);
        }
        this.subject.addProperty(this.entryProperty, (RDFNode)entry);
        ResourceUtils.setProperty(entry, this.keyProperty, key);
        ResourceUtils.setProperty(entry, this.valueProperty, value);
        return entry;
    }

    @Override
    public Set<Map.Entry<RDFNode, RDFNode>> entrySet() {
        Converter converter = Converter.from(e -> new RdfEntryWithCast(new RdfEntryKv(e.asNode(), (EnhGraph)e.getModel(), this.entryProperty, this.keyProperty, this.valueProperty), this.keyConverter, this.valueConverter), e -> (Resource)e);
        SetFromCollection result = new SetFromCollection((Collection)new ConvertingCollection((Collection)new SetFromPropertyValues<Resource>(this.subject, this.entryProperty, Resource.class){

            @Override
            public Iterator<Resource> iterator() {
                final Iterator baseIt = super.iterator();
                return new SinglePrefetchIterator<Resource>(){

                    protected Resource prefetch() throws Exception {
                        return baseIt.hasNext() ? (Resource)baseIt.next() : (Resource)this.finish();
                    }

                    protected void doRemove(Resource item) {
                        item.removeAll(MapFromResource.this.keyProperty);
                        item.removeAll(MapFromResource.this.valueProperty);
                        baseIt.remove();
                    }
                };
            }
        }, converter));
        return result;
    }
}

