/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import com.google.common.base.Converter;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;

public class ConverterFromNodeMapperAndModel<R extends RDFNode, J>
extends Converter<R, J> {
    protected Model model;
    protected Converter<Node, J> converter;
    protected Class<R> rdfViewClass;

    public ConverterFromNodeMapperAndModel(Model model, Class<R> rdfViewClass, Converter<Node, J> converter) {
        this.model = model;
        this.converter = converter;
        this.rdfViewClass = rdfViewClass;
    }

    protected J doForward(R a) {
        Node node = a.asNode();
        Object result = this.converter.convert((Object)node);
        return (J)result;
    }

    protected R doBackward(J b) {
        Node node = (Node)this.converter.reverse().convert(b);
        RDFNode tmp = this.model.asRDFNode(node);
        RDFNode result = tmp.as(this.rdfViewClass);
        return (R)result;
    }
}

