/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.proxy;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.common.DefaultPrefixes;
import org.aksw.jena_sparql_api.mapper.proxy.TypeDecider;
import org.aksw.jenax.annotation.reprogen.RdfType;
import org.aksw.jenax.annotation.reprogen.RdfTypeNs;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.vocabulary.RDF;

public class TypeDeciderImpl
implements TypeDecider {
    protected PrefixMapping prefixMapping;
    protected Property typeProperty;
    protected Map<Node, Class<?>> nodeToClass;
    protected Map<Class<?>, Node> classToNode;

    public String toString() {
        return "TypeDeciderImpl [typeProperty= " + String.valueOf(this.typeProperty) + ", nodeToClass.size=" + this.nodeToClass.size() + ", classToNode.size=" + this.classToNode.size() + "]";
    }

    public TypeDeciderImpl() {
        this(RDF.type, new HashMap(), new HashMap(), DefaultPrefixes.get());
    }

    public TypeDeciderImpl(Property typeProperty, Map<Node, Class<?>> nodeToClass, Map<Class<?>, Node> classToNode, PrefixMapping prefixMapping) {
        this.typeProperty = typeProperty;
        this.nodeToClass = nodeToClass;
        this.classToNode = classToNode;
        this.prefixMapping = prefixMapping;
    }

    public synchronized void put(Class<?> clazz, Node node) {
        this.nodeToClass.put(node, clazz);
        this.classToNode.put(clazz, node);
    }

    public synchronized void putAll(Map<Class<?>, Node> map) {
        map.entrySet().forEach(e -> this.put((Class)e.getKey(), (Node)e.getValue()));
    }

    public TypeDeciderImpl scan(Class<?> protoClass) {
        String basePackage = protoClass.getPackage().getName();
        Map<Class<?>, Node> map = TypeDeciderImpl.scan(basePackage);
        this.putAll(map);
        return this;
    }

    @Override
    public Collection<Class<?>> getApplicableTypes(Resource subject) {
        Set<Class<?>> result = subject.listProperties(this.typeProperty).toSet().stream().map(stmt -> stmt.getObject().asNode()).map(o -> this.nodeToClass.get(o)).filter(o -> o != null).collect(Collectors.toSet());
        return result;
    }

    @Override
    public void writeTypeTriples(Resource outResource, Class<?> clazz) {
        Model model;
        RDFNode rdfNode;
        boolean isAlreadyPresent;
        Node type = this.classToNode.get(clazz);
        if (type != null && !(isAlreadyPresent = outResource.hasProperty(this.typeProperty, rdfNode = ModelUtils.convertGraphNodeToRDFNode((Node)type, (Model)(model = outResource.getModel()))))) {
            outResource.addProperty(this.typeProperty, rdfNode);
        }
    }

    public TypeDeciderImpl registerClasses(Class<?> ... classes) {
        return this.registerClasses(Arrays.asList(classes));
    }

    public TypeDeciderImpl registerClasses(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            Map<Class<?>, Node> map = TypeDeciderImpl.processClass(clazz, this.prefixMapping);
            this.putAll(map);
        }
        return this;
    }

    public static Map<Class<?>, Node> scan(String basePackage) {
        Map<Class<?>, Node> result = TypeDeciderImpl.scan(basePackage, DefaultPrefixes.get());
        return result;
    }

    public static Map<Class<?>, Node> processClass(Class<?> clazz, PrefixMapping prefixMapping) {
        Map<Class<?>, Node> result;
        RdfType rdfType = clazz.getAnnotation(RdfType.class);
        RdfTypeNs rdfTypeNs = clazz.getAnnotation(RdfTypeNs.class);
        if (rdfTypeNs != null) {
            String ns = rdfTypeNs.value();
            String uri = prefixMapping.getNsPrefixURI(ns);
            if (uri == null) {
                throw new RuntimeException("Undefined prefix: " + ns + " on class " + String.valueOf(clazz));
            }
            String localName = clazz.getSimpleName();
            String expanded = uri + localName;
            Node node = NodeFactory.createURI((String)expanded);
            result = Collections.singletonMap(clazz, node);
        } else if (rdfType != null) {
            Object iri = rdfType.value();
            if (Strings.isNullOrEmpty((String)iri)) {
                iri = "java://" + clazz.getCanonicalName();
            }
            String expanded = prefixMapping.expandPrefix((String)iri);
            Node node = NodeFactory.createURI((String)expanded);
            result = Collections.singletonMap(clazz, node);
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    public static Map<Class<?>, Node> scan(String basePackage, PrefixMapping prefixMapping) {
        ImmutableSet classInfos;
        HashMap result = new HashMap();
        try {
            classInfos = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader()).getTopLevelClassesRecursive(basePackage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (ClassPath.ClassInfo classInfo : classInfos) {
            Class clazz = classInfo.load();
            TypeDeciderImpl.processClass(clazz, prefixMapping);
        }
        return result;
    }
}

