/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.views.map;

import com.google.common.base.Supplier;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.sets.SetFromCollection;

public class MapFromMultimap<K, V>
extends AbstractMap<K, V> {
    protected Multimap<K, V> multimap;

    public MapFromMultimap(Multimap<K, V> multimap) {
        this.multimap = multimap;
    }

    @Override
    public V get(Object k) {
        Object result = null;
        if (this.multimap.containsKey(k)) {
            Collection col = this.multimap.get(k);
            if (col.size() > 1) {
                throw new IllegalStateException("Map wrapper for a multimap encountered multiple values");
            }
            result = col.isEmpty() ? null : col.iterator().next();
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.multimap.put(key, value);
        return value;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.multimap.containsKey(key);
    }

    @Override
    public V remove(Object key) {
        V result = this.get(key);
        this.multimap.removeAll(key);
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetFromCollection(this.multimap.entries());
    }

    public static <K, V> Map<K, V> createView(Map<K, Collection<V>> map) {
        Multimap<K, V> multimap = MapFromMultimap.createView(map, () -> null);
        MapFromMultimap<K, V> result = new MapFromMultimap<K, V>(multimap);
        return result;
    }

    public static <K, V> Multimap<K, V> createView(final Map<K, Collection<V>> map, Supplier<? extends Collection<V>> factory) {
        final boolean[] fakeEmpty = new boolean[]{true};
        ForwardingMap wrapper = new ForwardingMap<K, Collection<V>>(){

            protected Map<K, Collection<V>> delegate() {
                return map;
            }

            public boolean isEmpty() {
                return fakeEmpty[0] ? true : super.isEmpty();
            }
        };
        Multimap result = Multimaps.newMultimap((Map)wrapper, factory);
        fakeEmpty[0] = false;
        return result;
    }
}

