/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.views.map;

import org.aksw.commons.util.convert.ConvertFunction;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntry;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntryDelegateBase;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class RdfEntryWithCast<K extends RDFNode, V extends RDFNode>
extends RdfEntryDelegateBase<K, V> {
    protected ConvertFunction<? super RDFNode, K> keyConverter;
    protected ConvertFunction<? super RDFNode, V> valueConverter;

    public RdfEntryWithCast(RdfEntry<?, ?> delegate, ConvertFunction<? super RDFNode, K> keyConverter, ConvertFunction<? super RDFNode, V> valueConverter) {
        super(delegate);
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    public ConvertFunction<? super RDFNode, ? extends RDFNode> getKeyConverter() {
        return this.keyConverter;
    }

    public ConvertFunction<? super RDFNode, ? extends RDFNode> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public K getKey() {
        RDFNode r = (RDFNode)this.getDelegate().getKey();
        if (r != null && this.keyConverter != null) {
            r = (RDFNode)this.keyConverter.convert((Object)r);
        }
        return (K)r;
    }

    @Override
    public V getValue() {
        RDFNode r = (RDFNode)this.getDelegate().getValue();
        if (r != null && this.valueConverter != null) {
            r = (RDFNode)this.valueConverter.convert((Object)r);
        }
        return (V)r;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("setValue not implemented");
    }

    @Override
    public RdfEntry<K, V> inModel(Model m) {
        Resource newDelegate = this.getDelegate().inModel(m);
        return new RdfEntryWithCast<K, V>((RdfEntry<?, ?>)newDelegate, this.keyConverter, this.valueConverter);
    }
}

