/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.views.map;

import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntryOwnerBase;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;

public class RdfEntryKv
extends RdfEntryOwnerBase<RDFNode, RDFNode> {
    protected Property valueProperty;

    public RdfEntryKv(Node n, EnhGraph g, Property ownerProperty, Property keyProperty, Property valueProperty) {
        super(n, g, ownerProperty, keyProperty);
        this.valueProperty = valueProperty;
    }

    @Override
    public RDFNode getKey() {
        RDFNode result = ResourceUtils.getPropertyValue(this, this.keyProperty);
        return result;
    }

    @Override
    public RDFNode getValue() {
        RDFNode result = ResourceUtils.getPropertyValue(this, this.valueProperty);
        return result;
    }

    @Override
    public RdfEntryKv inModel(Model m) {
        return m == this.getModel() ? this : new RdfEntryKv(this.node, (EnhGraph)m, this.ownerProperty, this.keyProperty, this.valueProperty);
    }

    @Override
    public RDFNode setValue(RDFNode value) {
        RDFNode result = this.getValue();
        ResourceUtils.setProperty(this, this.valueProperty, value);
        return result;
    }

    public void clear() {
        this.removeAll(this.valueProperty);
        this.removeAll(this.keyProperty);
    }
}

