/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.views.map;

import com.google.common.base.Converter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.commons.collections.sets.SetFromCollection;
import org.aksw.commons.util.convert.ConvertFunction;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.rdf.collections.SetFromPropertyValues;
import org.aksw.jena_sparql_api.utils.views.map.MapFromResourceBase;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntryK;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntryWithCast;
import org.aksw.jena_sparql_api.utils.views.map.RdfMap;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public class MapFromResourceUnmanaged
extends MapFromResourceBase<RDFNode, Resource>
implements RdfMap<RDFNode, Resource> {
    protected final Property entryProperty;
    protected final Property keyProperty;
    protected BiFunction<Resource, RDFNode, Resource> sAndKeyToEntry;
    protected final boolean removeKeyFromEntryUponUnlinking = true;

    public MapFromResourceUnmanaged(Resource subject, Property entryProperty, Property keyProperty) {
        this(subject, entryProperty, keyProperty, null, null, (s, k) -> s.getModel().createResource());
    }

    public MapFromResourceUnmanaged(Resource subject, Property entryProperty, Property keyProperty, ConvertFunction<? super RDFNode, RDFNode> keyConverter, ConvertFunction<? super RDFNode, Resource> valueConverter) {
        this(subject, entryProperty, keyProperty, keyConverter, valueConverter, (s, k) -> s.getModel().createResource());
    }

    public MapFromResourceUnmanaged(Resource subject, Property entryProperty, Property keyProperty, ConvertFunction<? super RDFNode, RDFNode> keyConverter, ConvertFunction<? super RDFNode, Resource> valueConverter, BiFunction<Resource, RDFNode, Resource> sAndKeyToEntry) {
        super(subject, keyConverter, valueConverter);
        this.entryProperty = entryProperty;
        this.keyProperty = keyProperty;
        this.sAndKeyToEntry = sAndKeyToEntry;
    }

    @Override
    public Resource get(Object key) {
        Resource result = key instanceof RDFNode ? this.get((RDFNode)key) : null;
        return result;
    }

    public Resource get(RDFNode key) {
        Resource result = this.getViaModel(key);
        return result;
    }

    public Resource getViaModel(RDFNode key) {
        Model model = this.subject.getModel();
        Resource result = model.listStatements(null, this.keyProperty, key).mapWith(Statement::getSubject).filterKeep(e -> model.contains(this.subject, this.entryProperty, (RDFNode)e)).nextOptional().orElse(null);
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        Resource r = this.get(key);
        boolean result = r != null;
        return result;
    }

    @Override
    public Resource allocate(RDFNode key) {
        Resource result = this.get(key);
        if (result == null) {
            result = this.sAndKeyToEntry.apply(this.subject, key);
            this.put(key, result);
        }
        return result;
    }

    @Override
    public Resource put(RDFNode key, Resource entry) {
        Resource existing = this.get(key);
        Resource e = entry.inModel(this.subject.getModel());
        if (!Objects.equals(existing, entry) && existing != null) {
            this.subject.getModel().remove(this.subject, this.entryProperty, (RDFNode)existing);
            existing.removeAll(this.keyProperty);
        }
        this.subject.addProperty(this.entryProperty, (RDFNode)e);
        ResourceUtils.setProperty(e, this.keyProperty, key);
        return entry;
    }

    @Override
    public Set<Map.Entry<RDFNode, Resource>> entrySet() {
        Converter converter = Converter.from(e -> new RdfEntryWithCast(new RdfEntryK(e.asNode(), (EnhGraph)e.getModel(), this.entryProperty, this.keyProperty), this.keyConverter, this.valueConverter), e -> (Resource)e.getValue());
        SetFromCollection result = new SetFromCollection((Collection)new ConvertingCollection((Collection)new SetFromPropertyValues<Resource>(this.subject, this.entryProperty, Resource.class){

            @Override
            public Iterator<Resource> iterator() {
                final Iterator baseIt = super.iterator();
                return new SinglePrefetchIterator<Resource>(){

                    protected Resource prefetch() throws Exception {
                        return baseIt.hasNext() ? (Resource)baseIt.next() : (Resource)this.finish();
                    }

                    protected void doRemove(Resource item) {
                        item.removeAll(MapFromResourceUnmanaged.this.keyProperty);
                        baseIt.remove();
                    }
                };
            }
        }, converter));
        return result;
    }
}

