/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.aksw.jena_sparql_api.rdf.collections.RdfBackedCollection;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SetFromPropertyValues<T extends RDFNode>
extends AbstractSet<T>
implements RdfBackedCollection<T> {
    protected Resource subject;
    protected Property property;
    protected boolean isFwd;
    protected Class<T> clazz;

    public SetFromPropertyValues(Resource subject, Property property, Class<T> clazz) {
        this(subject, property, true, clazz);
    }

    public SetFromPropertyValues(Resource subject, Property property, boolean isFwd, Class<T> clazz) {
        this.subject = subject;
        this.property = property;
        this.isFwd = isFwd;
        this.clazz = clazz;
    }

    @Override
    public boolean add(T o) {
        boolean result = ResourceUtils.addProperty((RDFNode)this.subject, this.property, this.isFwd, o);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = false;
        if (o instanceof RDFNode) {
            RDFNode n = (RDFNode)o;
            Model m = this.subject.getModel();
            result = this.isFwd ? m.contains(this.subject, this.property, n) : (n.isResource() ? m.contains(n.asResource(), this.property, (RDFNode)this.subject) : false);
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        ExtendedIterator<T> result = ResourceUtils.listPropertyValues(this.subject, this.property, this.isFwd, this.clazz);
        return result;
    }

    @Override
    public int size() {
        int result = Iterators.size(this.iterator());
        return result;
    }

    @Override
    public Collection<RDFNode> getRawCollection() {
        return new SetFromPropertyValues<RDFNode>(this.subject, this.property, this.isFwd, RDFNode.class);
    }
}

