/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.aksw.commons.util.reflect.ClassUtils;
import org.aksw.jena_sparql_api.mapper.proxy.TypeDecider;
import org.aksw.jena_sparql_api.rdf.collections.ForwardingIteratorWithForcedRemoval;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperFromRdfDatatype;
import org.aksw.jena_sparql_api.rdf.collections.RDFNodeMapper;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.rdf.model.impl.StatementTermImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathLib;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class ResourceUtils {
    public static Model bnodeClosure(Resource root) {
        Model m = ModelFactory.createDefaultModel();
        Set seen = CollectionFactory.createHashedSet();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(root);
        while (!queue.isEmpty()) {
            Resource r = (Resource)queue.remove(0);
            if (seen.contains(r)) continue;
            seen.add(r);
            StmtIterator i = r.listProperties();
            while (i.hasNext()) {
                Statement s = i.nextStatement();
                m.add(s);
                RDFNode obj = s.getObject();
                if (!obj.isAnon()) continue;
                queue.add(s.getObject());
            }
        }
        return m;
    }

    public static RDFNode asBasicRdfNode(RDFNode rdfNode) {
        Object result;
        if (rdfNode == null) {
            result = null;
        } else {
            Class<?> clazz = rdfNode.getClass();
            Node n = rdfNode.asNode();
            Model m = rdfNode.getModel();
            result = rdfNode instanceof Property ? (clazz.equals(PropertyImpl.class) ? rdfNode : new PropertyImpl(n, (EnhGraph)((ModelCom)m))) : (clazz.equals(ResourceImpl.class) || clazz.equals(LiteralImpl.class) ? rdfNode : ModelUtils.convertGraphNodeToRDFNode((Node)n, (Model)m));
        }
        return result;
    }

    public static Resource asResource(Node node, Graph graph) {
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        RDFNode tmp = ModelUtils.convertGraphNodeToRDFNode((Node)node, (Model)model);
        Resource result = tmp.asResource();
        return result;
    }

    public static <T> Stream<T> asStream(ExtendedIterator<T> it) {
        Stream result = (Stream)Streams.stream(it).onClose(() -> it.close());
        return result;
    }

    public static <T> Optional<T> findFirst(Stream<T> stream) {
        Optional<T> result;
        try (Stream<T> tmp = stream;){
            result = stream.findFirst();
        }
        return result;
    }

    public static <T> Optional<T> findFirst(ExtendedIterator<T> stream) {
        Optional result = stream.nextOptional();
        stream.close();
        return result;
    }

    public static <T extends RDFNode> boolean canAsProperty(Statement stmt, boolean isFwd, Class<T> clazz) {
        RDFNode rdfNode = ResourceUtils.getTarget(stmt, isFwd);
        boolean result = rdfNode.canAs(clazz);
        return result;
    }

    public static <T extends RDFNode> boolean canAsPropertyNode(Statement stmt, boolean isFwd, Predicate<Node> nodeTest) {
        RDFNode rdfNode = ResourceUtils.getTarget(stmt, isFwd);
        Node node = rdfNode.asNode();
        boolean result = nodeTest.test(node);
        return result;
    }

    public static <T extends RDFNode> boolean canAsProperty(Statement stmt, boolean isFwd, Predicate<RDFNode> nodeTest) {
        RDFNode rdfNode = ResourceUtils.getTarget(stmt, isFwd);
        boolean result = nodeTest.test(rdfNode);
        return result;
    }

    public static <T extends RDFNode> T getPropertyValue(Statement stmt, boolean isFwd, Class<T> clazz) {
        RDFNode rdfNode = ResourceUtils.getTarget(stmt, isFwd);
        RDFNode result = rdfNode.as(clazz);
        return (T)result;
    }

    public static <T> T getPropertyValue(Statement stmt, boolean isFwd, NodeMapper<T> nodeMapper) {
        RDFNode rdfNode = ResourceUtils.getTarget(stmt, isFwd);
        Node node = rdfNode.asNode();
        Object result = nodeMapper.toJava(node);
        return result;
    }

    public static <T> T getPropertyValue(Statement stmt, boolean isFwd, RDFNodeMapper<T> rdfNodeMapper) {
        RDFNode rdfNode = ResourceUtils.getTarget(stmt, isFwd);
        Object result = rdfNodeMapper.toJava(rdfNode);
        return result;
    }

    public static boolean canAsLiteral(Statement stmt, Class<?> clazz) {
        TypeMapper tm = TypeMapper.getInstance();
        RDFDatatype dtype = tm.getTypeByClass(clazz);
        RDFNode o = stmt.getObject();
        Node node = o.asNode();
        Object obj = node.isLiteral() ? node.getLiteral().getValue() : null;
        Class<?> oClass = obj == null ? null : obj.getClass();
        boolean result = oClass != null && clazz.isAssignableFrom(oClass) || dtype != null && o.isLiteral() && NodeMapperFromRdfDatatype.canMapCore(node, dtype);
        return result;
    }

    public static <T> Literal createTypedLiteral(Model model, Class<T> clazz, T o) {
        TypeMapper tm = TypeMapper.getInstance();
        RDFDatatype dtype = tm.getTypeByClass(clazz);
        Literal result = model.createTypedLiteral(o, dtype);
        return result;
    }

    public static <T> T getLiteralValue(Statement stmt, Class<T> clazz) {
        RDFNode o = stmt.getObject();
        Node node = o.asNode();
        Object result = NodeMapperFromRdfDatatype.toJavaCore(node, clazz);
        return result;
    }

    public static <T extends RDFNode> ExtendedIterator<Statement> listProperties(Resource s, Property p, boolean isFwd, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p, isFwd).filterKeep(stmt -> ResourceUtils.canAsProperty(stmt, isFwd, clazz));
        return result;
    }

    public static <T extends RDFNode> ExtendedIterator<T> listPropertyValues(Resource s, Property p, boolean isFwd, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p, isFwd, clazz).mapWith(stmt -> ResourceUtils.getPropertyValue(stmt, isFwd, clazz));
        return result;
    }

    public static <T extends RDFNode> ExtendedIterator<T> listPropertyValues(Model model, Resource s, Property p, boolean isFwd, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listProperties(model, (RDFNode)s, p, isFwd).filterKeep(stmt -> ResourceUtils.canAsProperty(stmt, isFwd, clazz)).mapWith(stmt -> ResourceUtils.getPropertyValue(stmt, isFwd, clazz));
        return result;
    }

    public static StmtIterator listStatementsWithRemovalAllowed(Model m, Resource s, Property p, RDFNode o) {
        Graph g = m.getGraph();
        Node ns = s == null ? Node.ANY : s.asNode();
        Node np = p == null ? Node.ANY : p.asNode();
        Node no = o == null ? Node.ANY : o.asNode();
        ExtendedIterator coreIt = g.find(ns, np, no);
        ForwardingIteratorWithForcedRemoval<Triple> it = new ForwardingIteratorWithForcedRemoval<Triple>((Iterator<Triple>)coreIt, triple -> m.getGraph().delete(triple));
        return ResourceUtils.asStmtIterator(it, (ModelCom)m);
    }

    public static StmtIterator listProperties(Resource s) {
        Model m = s.getModel();
        StmtIterator result = ResourceUtils.listStatementsWithRemovalAllowed(m, s, null, null);
        return result;
    }

    public static StmtIterator listProperties(Resource s, Property p) {
        Model m = s.getModel();
        StmtIterator result = ResourceUtils.listStatementsWithRemovalAllowed(m, s, p, null);
        return result;
    }

    public static ExtendedIterator<RDFNode> listPropertyValues(Resource s, Property p) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p).mapWith(Statement::getObject);
        return result;
    }

    public static Optional<Statement> getProperty(Resource s, Property p) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listProperties(s, p));
        return result;
    }

    public static Optional<RDFNode> tryGetPropertyValue(Resource s, Property p) {
        Optional<RDFNode> result = ResourceUtils.getProperty(s, p).map(Statement::getObject);
        return result;
    }

    public static RDFNode getPropertyValue(Resource s, Property p) {
        RDFNode result = ResourceUtils.tryGetPropertyValue(s, p).orElse(null);
        return result;
    }

    public static <T> ExtendedIterator<Statement> listProperties(Resource s, Property p, boolean isFwd, NodeMapper<T> nodeMapper) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p).filterKeep(stmt -> ResourceUtils.canAsPropertyNode(stmt, isFwd, nodeMapper::canMap));
        return result;
    }

    public static <T> ExtendedIterator<Statement> listProperties(Resource s, Property p, boolean isFwd, RDFNodeMapper<T> rdfNodeMapper) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p, isFwd).filterKeep(stmt -> ResourceUtils.canAsProperty(stmt, isFwd, rdfNodeMapper::canMap));
        return result;
    }

    public static <T> Set<T> lowestCommonAncestors(T a, T b, Function<? super T, ? extends Iterable<? extends T>> successor) {
        HashSet<T> parentsA = new HashSet<T>();
        HashSet<T> parentsB = new HashSet<T>();
        parentsA.add(a);
        parentsB.add(b);
        Sets.SetView intersection = Sets.intersection(parentsA, parentsB);
        while (intersection.isEmpty() && (a != null || b != null)) {
            Iterable<? extends T> pa = a == null ? null : successor.apply(a);
            Iterable<? extends T> pb = b == null ? null : successor.apply(b);
            Iterables.addAll(parentsA, pa);
            if (!intersection.isEmpty()) break;
            Iterables.addAll(parentsB, pb);
        }
        HashSet result = new HashSet(intersection);
        return result;
    }

    public static Iterable<Class<?>> getParentClasses(Class<?> child) {
        return Iterables.concat(Collections.singleton(child.getSuperclass()), Arrays.asList(child.getInterfaces()));
    }

    public static Class<?> getMostSpecificSubclass(Resource s, Class<?> viewClass, TypeDecider typeDecider) {
        Collection<Class<?>> classes = typeDecider.getApplicableTypes(s);
        Set mscs = ClassUtils.getMostSpecificSubclasses(viewClass, classes);
        Class<?> result = mscs.size() == 1 ? (Class<?>)mscs.iterator().next() : (mscs.size() > 1 ? viewClass : null);
        return result;
    }

    void setObject(Object o) {
    }

    public static <T> Optional<T> tryGetPropertyValue(Resource s, Property p, boolean isFwd, RDFNodeMapper<T> rdfNodeMapper) {
        Optional<T> result = ResourceUtils.findFirst(ResourceUtils.listPropertyValues(s, p, isFwd, rdfNodeMapper));
        return result;
    }

    public static <T> Optional<T> tryGetPropertyValue(Resource s, Property p, boolean isFwd, NodeMapper<T> nodeMapper) {
        Optional<T> result = ResourceUtils.findFirst(ResourceUtils.listPropertyValues(s, p, isFwd, nodeMapper));
        return result;
    }

    public static <T> T getPropertyValue(Resource s, Property p, boolean isFwd, NodeMapper<T> nodeMapper) {
        T result = ResourceUtils.tryGetPropertyValue(s, p, isFwd, nodeMapper).orElse(null);
        return result;
    }

    public static <T> T getPropertyValue(Resource s, Property p, boolean isFwd, RDFNodeMapper<T> rdfNodeMapper) {
        T result = ResourceUtils.tryGetPropertyValue(s, p, isFwd, rdfNodeMapper).orElse(null);
        return result;
    }

    public static <T> ExtendedIterator<T> listPropertyValues(Resource s, Property p, boolean isFwd, NodeMapper<T> nodeMapper) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p, isFwd, nodeMapper).mapWith(stmt -> ResourceUtils.getPropertyValue(stmt, isFwd, nodeMapper));
        return result;
    }

    public static <T> ExtendedIterator<T> listPropertyValues(Resource s, Property p, boolean isFwd, RDFNodeMapper<T> rdfNodeMapper) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p, isFwd, rdfNodeMapper).mapWith(stmt -> ResourceUtils.getPropertyValue(stmt, isFwd, rdfNodeMapper));
        return result;
    }

    public static <T extends RDFNode> Optional<Statement> getProperty(Resource s, Property p, boolean isFwd, Class<T> clazz) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listProperties(s, p, isFwd, clazz));
        return result;
    }

    public static <T extends RDFNode> Optional<T> tryGetPropertyValue(Resource s, Property p, boolean isFwd, Class<T> clazz) {
        Optional<RDFNode> result = ResourceUtils.getProperty(s, p, isFwd, clazz).map(stmt -> ResourceUtils.getPropertyValue(stmt, isFwd, clazz));
        return result;
    }

    public static <T extends RDFNode> T getPropertyValue(Resource s, Property p, boolean isFwd, Class<T> clazz) {
        RDFNode result = ResourceUtils.tryGetPropertyValue(s, p, isFwd, clazz).orElse(null);
        return (T)result;
    }

    public static <T> ExtendedIterator<Statement> listLiteralProperties(Resource s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p).filterKeep(stmt -> ResourceUtils.canAsLiteral(stmt, clazz));
        return result;
    }

    public static <T> ExtendedIterator<T> listLiteralPropertyValues(Resource s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listLiteralProperties(s, p, clazz).mapWith(stmt -> ResourceUtils.getLiteralValue(stmt, clazz));
        return result;
    }

    public static <T> Optional<Statement> getLiteralProperty(Resource s, Property p, Class<T> clazz) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listLiteralProperties(s, p, clazz));
        return result;
    }

    public static <T> Optional<T> tryGetLiteralPropertyValue(Resource s, Property p, Class<T> clazz) {
        Optional<Object> result = ResourceUtils.getLiteralProperty(s, p, clazz).map(stmt -> ResourceUtils.getLiteralValue(stmt, clazz));
        return result;
    }

    public static <T> T getLiteralPropertyValue(Resource s, Property p, Class<T> clazz) {
        T result = ResourceUtils.tryGetLiteralPropertyValue(s, p, clazz).orElse(null);
        return result;
    }

    public static StmtIterator listProperties(RDFNode s, boolean isFwd) {
        StmtIterator result = isFwd ? s.asResource().listProperties() : ResourceUtils.listReverseProperties(s);
        return result;
    }

    public static StmtIterator listReverseProperties(RDFNode s) {
        StmtIterator result = s.getModel().listStatements(null, null, s);
        return result;
    }

    public static StmtIterator listReverseProperties(RDFNode s, Property p) {
        StmtIterator result = s.getModel().listStatements(null, p, s);
        return result;
    }

    public static Statement getReverseProperty(RDFNode s, Property p) {
        Statement result = ResourceUtils.tryGetReverseProperty(s, p).orElse(null);
        return result;
    }

    public static Optional<Statement> tryGetReverseProperty(RDFNode s, Property p) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listReverseProperties(s, p));
        return result;
    }

    public static <T extends Resource> boolean isReverseProperty(Statement stmt, Class<T> clazz) {
        boolean result = stmt.getSubject().canAs(clazz);
        return result;
    }

    public static <T extends Resource> ExtendedIterator<Statement> listReverseProperties(RDFNode s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listReverseProperties(s, p).filterKeep(stmt -> ResourceUtils.isReverseProperty(stmt, clazz));
        return result;
    }

    public static <T extends Resource> Optional<Statement> getReverseProperty(RDFNode s, Property p, Class<T> clazz) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listReverseProperties(s, p, clazz));
        return result;
    }

    public static Optional<Resource> tryGetReversePropertyValue(Resource s, Property p) {
        Optional<Resource> result = ResourceUtils.tryGetReverseProperty((RDFNode)s, p).map(Statement::getSubject);
        return result;
    }

    public static Resource getReversePropertyValue(Resource s, Property p) {
        Resource result = ResourceUtils.tryGetReversePropertyValue(s, p).orElse(null);
        return result;
    }

    public static <T extends Resource> Optional<T> tryGetReversePropertyValue(Resource s, Property p, Class<T> clazz) {
        Optional<Resource> result = ResourceUtils.getReverseProperty((RDFNode)s, p, clazz).map(Statement::getSubject).map(r -> (Resource)r.as(clazz));
        return result;
    }

    public static <T extends Resource> T getReversePropertyValue(Resource s, Property p, Class<T> clazz) {
        Resource result = ResourceUtils.tryGetReversePropertyValue(s, p, clazz).orElse(null);
        return (T)result;
    }

    public static ExtendedIterator<Resource> listReversePropertyValues(Resource s, Property p) {
        ExtendedIterator result = ResourceUtils.listReverseProperties((RDFNode)s, p).mapWith(Statement::getSubject);
        return result;
    }

    public static <T extends Resource> ExtendedIterator<T> listReversePropertyValues(RDFNode s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listReverseProperties(s, p, clazz).mapWith(stmt -> (Resource)stmt.getSubject().as(clazz));
        return result;
    }

    public static boolean addProperty(RDFNode s, Property p, boolean isFwd, RDFNode o) {
        boolean result = isFwd ? ResourceUtils.addFwdProperty(s.asResource(), p, o) : ResourceUtils.addFwdProperty(o.asResource(), p, s);
        return result;
    }

    public static boolean addFwdProperty(Resource s, Property p, RDFNode o) {
        boolean result = false;
        if (o != null && !s.hasProperty(p, o)) {
            s.addProperty(p, o);
            result = true;
        }
        return result;
    }

    public static boolean addLiteral(Resource s, Property p, Object o) {
        boolean result = false;
        if (o != null && !s.hasLiteral(p, o)) {
            s.addLiteral(p, o);
            result = true;
        }
        return result;
    }

    public static boolean addReverseProperty(RDFNode s, Property p, Resource o) {
        Resource newS = o.inModel(s.getModel());
        RDFNode newO = s;
        boolean result = ResourceUtils.addFwdProperty(newS, p, newO);
        return result;
    }

    public static boolean replaceProperties(Model m, ExtendedIterator<Statement> removals, Statement stmt) {
        boolean result = ResourceUtils.replacePropertiesUsingIterator(m, removals, stmt);
        return result;
    }

    public static boolean replacePropertiesUsingModel(Model m, ExtendedIterator<Statement> removals, Statement newStmt) {
        boolean result;
        Set stmts = removals.toSet();
        boolean stmtSeen = false;
        for (Statement stmt : stmts) {
            Statement item = (Statement)removals.next();
            if (item.equals((Object)stmt)) {
                stmtSeen = true;
                continue;
            }
            m.remove(stmt);
        }
        boolean bl = result = newStmt != null && !stmtSeen;
        if (result) {
            m.add(newStmt);
        }
        return result;
    }

    public static boolean replacePropertiesUsingIterator(Model m, ExtendedIterator<Statement> removals, Statement stmt) {
        boolean result;
        boolean stmtSeen = false;
        while (removals.hasNext()) {
            Statement item = (Statement)removals.next();
            if (item.equals((Object)stmt)) {
                stmtSeen = true;
                continue;
            }
            removals.remove();
        }
        boolean bl = result = stmt != null && !stmtSeen;
        if (result) {
            m.add(stmt);
        }
        return result;
    }

    public static boolean setProperty(Resource s, Property p, boolean isFwd, RDFNode o) {
        boolean result = ResourceUtils.replaceProperties(s.getModel(), (ExtendedIterator<Statement>)ResourceUtils.listProperties(s, p, isFwd), o == null ? null : ResourceUtils.createStatement((RDFNode)s, p, isFwd, o));
        return result;
    }

    public static <S extends Resource> S setLiteralProperty(S s, Property p, Object o) {
        ResourceUtils.replaceProperties(s.getModel(), (ExtendedIterator<Statement>)ResourceUtils.listProperties(s, p), o == null ? null : s.getModel().createLiteralStatement(s, p, o));
        return s;
    }

    public static <T> boolean setProperty(Resource s, Property p, boolean isFwd, NodeMapper<T> nodeMapper, T value) {
        RDFNode v = value == null ? null : s.getModel().asRDFNode((Node)nodeMapper.toNode(value));
        boolean result = ResourceUtils.replaceProperties(s.getModel(), ResourceUtils.listProperties(s, p, isFwd, nodeMapper), v == null ? null : ResourceUtils.createStatement((RDFNode)s, p, isFwd, v));
        return result;
    }

    public static Statement createStatement(RDFNode s, Property p, boolean isFwd, RDFNode o) {
        Model m = s.getModel();
        Statement result = isFwd ? m.createStatement(s.asResource(), p, o) : m.createStatement(o.asResource(), p, s);
        return result;
    }

    public static <T> boolean updateProperty(Resource s, Property p, boolean isFwd, NodeMapper<T> nodeMapper, T o) {
        Model m = s.getModel();
        boolean result = ResourceUtils.replaceProperties(m, ResourceUtils.listProperties(s, p, isFwd, nodeMapper), o == null ? null : ResourceUtils.createStatement((RDFNode)s, p, isFwd, m.asRDFNode((Node)nodeMapper.toNode(o))));
        return result;
    }

    public static <T> boolean updateLiteralProperty(Resource s, Property p, Class<T> clazz, T o) {
        Model m = s.getModel();
        boolean result = ResourceUtils.replaceProperties(m, ResourceUtils.listLiteralProperties(s, p, clazz), o == null ? null : m.createStatement(s, p, (RDFNode)ResourceUtils.createTypedLiteral(m, clazz, o)));
        return result;
    }

    public static <T> boolean updateProperty(Resource s, Property p, boolean isFwd, RDFNodeMapper<T> rdfNodeMapper, T o) {
        Model m = s.getModel();
        boolean result = ResourceUtils.replaceProperties(m, ResourceUtils.listProperties(s, p, isFwd, rdfNodeMapper), o == null ? null : ResourceUtils.createStatement((RDFNode)s, p, isFwd, (RDFNode)rdfNodeMapper.toNode(o)));
        return result;
    }

    public static <T extends RDFNode> boolean updateProperty(Resource s, Property p, boolean isFwd, Class<T> clazz, T o) {
        boolean result = ResourceUtils.replaceProperties(s.getModel(), ResourceUtils.listProperties(s, p, isFwd, clazz), o == null ? null : s.getModel().createStatement(s, p, o));
        return result;
    }

    public static <T extends Resource> boolean setReverseProperty(RDFNode s, Property p, Class<T> clazz, T o) {
        boolean result = ResourceUtils.replaceProperties(s.getModel(), ResourceUtils.listReverseProperties(s, p, clazz), o == null ? null : s.getModel().createStatement(o, p, s));
        return result;
    }

    public static <T extends Resource> boolean hasProperty(Resource s, Property p, boolean isFwd, Class<T> clazz) {
        boolean result = ResourceUtils.getProperty(s, p, isFwd, clazz).isPresent();
        return result;
    }

    public static boolean hasReverseProperty(RDFNode s, Property p) {
        boolean result = ResourceUtils.tryGetReverseProperty(s, p).isPresent();
        return result;
    }

    public static <T extends Resource> boolean hasReverseProperty(RDFNode s, Property p, Class<T> clazz) {
        boolean result = ResourceUtils.getReverseProperty(s, p, clazz).isPresent();
        return result;
    }

    public static RDFNode getSource(RDFNode s, RDFNode o, boolean isFwd) {
        return isFwd ? s : o;
    }

    public static Model getSourceModel(RDFNode s, RDFNode o, boolean isFwd) {
        RDFNode tmp = ResourceUtils.getSource(s, o, isFwd);
        return tmp.getModel();
    }

    public static RDFNode getSource(Statement stmt, boolean isFwd) {
        Resource result = isFwd ? stmt.getSubject() : stmt.getObject();
        return result;
    }

    public static RDFNode getTarget(Statement stmt, boolean isFwd) {
        RDFNode result = isFwd ? stmt.getObject() : stmt.getSubject();
        return result;
    }

    public static Property getProperty(P_Path0 link) {
        PropertyImpl result = new PropertyImpl(link.getNode(), null);
        return result;
    }

    public static ExtendedIterator<RDFNode> listPropertyValues(Resource s, P_Path0 step) {
        boolean isFwd = step.isForward();
        return ResourceUtils.listProperties(s, step).mapWith(stmt -> ResourceUtils.getTarget(stmt, isFwd));
    }

    public static StmtIterator listProperties(Resource s, P_Path0 step) {
        boolean isFwd = step.isForward();
        Property p = ResourceUtils.getProperty(step);
        StmtIterator result = ResourceUtils.listProperties(s, p, isFwd);
        return result;
    }

    public static ExtendedIterator<RDFNode> listPropertyValues(Resource s, Property p, boolean isFwd) {
        return ResourceUtils.listProperties(s, p, isFwd).mapWith(stmt -> ResourceUtils.getTarget(stmt, isFwd));
    }

    public static StmtIterator listProperties(Resource s, Property p, boolean isFwd) {
        StmtIterator result = isFwd ? ResourceUtils.listProperties(s, p) : ResourceUtils.listReverseProperties((RDFNode)s, p);
        return result;
    }

    public static StmtIterator listProperties(Model m, RDFNode s, Property p, boolean isFwd) {
        String nullUri = "http://null.null/null";
        Node nullUriNode = NodeFactory.createURI((String)nullUri);
        Resource x = s == null ? null : (s.isResource() ? s.asResource() : m.wrapAsResource(nullUriNode));
        StmtIterator result = isFwd ? m.listStatements(x, p, (RDFNode)null) : m.listStatements(null, p, s);
        return result;
    }

    public static boolean setProperty(Resource s, Property p, RDFNode o) {
        boolean result = ResourceUtils.setProperty(s, p, true, o);
        return result;
    }

    public static <T> T getPropertyValue(Resource s, Property p, NodeMapper<T> nodeMapper) {
        T result = ResourceUtils.getPropertyValue(s, p, true, nodeMapper);
        return result;
    }

    public static <T extends RDFNode> T getPropertyValue(Resource s, Property p, Class<T> clazz) {
        T result = ResourceUtils.getPropertyValue(s, p, true, clazz);
        return result;
    }

    public static <T extends RDFNode> ExtendedIterator<T> listPropertyValues(Resource s, Property p, Class<T> clazz) {
        ExtendedIterator<T> result = ResourceUtils.listPropertyValues(s, p, true, clazz);
        return result;
    }

    public static <T> Optional<T> tryGetPropertyValue(Resource s, Property p, RDFNodeMapper<T> rdfNodeMapper) {
        Optional<T> result = ResourceUtils.tryGetPropertyValue(s, p, true, rdfNodeMapper);
        return result;
    }

    public static <T> Optional<T> tryGetPropertyValue(Resource s, Property p, NodeMapper<T> nodeMapper) {
        Optional<T> result = ResourceUtils.tryGetPropertyValue(s, p, true, nodeMapper);
        return result;
    }

    public static <T extends RDFNode> ExtendedIterator<T> listPropertyValues(Model model, Resource s, Property p, Class<T> clazz) {
        ExtendedIterator<T> result = ResourceUtils.listPropertyValues(model, s, p, true, clazz);
        return result;
    }

    public static <T extends RDFNode> T getPropertyValue(Statement stmt, Class<T> clazz) {
        T result = ResourceUtils.getPropertyValue(stmt, true, clazz);
        return result;
    }

    public static <T extends RDFNode> T getPropertyValue(Statement stmt, NodeMapper<T> nodeMapper) {
        RDFNode result = (RDFNode)ResourceUtils.getPropertyValue(stmt, true, nodeMapper);
        return (T)result;
    }

    public static <T extends RDFNode> T getPropertyValue(Statement stmt, RDFNodeMapper<T> rdfNodeMapper) {
        RDFNode result = (RDFNode)ResourceUtils.getPropertyValue(stmt, true, rdfNodeMapper);
        return (T)result;
    }

    public static Map<Resource, Resource> renameResources(Map<? extends RDFNode, String> rdfNodeToIri) {
        HashMap<Resource, Resource> result = new HashMap<Resource, Resource>();
        for (Map.Entry<? extends RDFNode, String> e : rdfNodeToIri.entrySet()) {
            RDFNode n = e.getKey();
            String iri = e.getValue();
            if (!n.isResource()) continue;
            Resource src = n.asResource();
            Resource tgt = org.apache.jena.util.ResourceUtils.renameResource((Resource)src, (String)iri);
            result.put(src, tgt);
        }
        return result;
    }

    public Stream<RDFNode> getReachableValues(RDFNode source, Path path, boolean isForward) {
        Model model = source.getModel();
        Node s = source.asNode();
        Var o = Var.alloc((String)"o");
        TriplePath tp = isForward ? new TriplePath(s, path, (Node)o) : new TriplePath((Node)o, path, s);
        DatasetGraph dsg = DatasetGraphFactory.wrap((Graph)source.getModel().getGraph());
        Context context = ARQ.getContext().copy();
        context.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        ExecutionContext execCxt = new ExecutionContext(context, dsg.getDefaultGraph(), dsg, QC.getFactory((Context)context));
        QueryIterator it = PathLib.execTriplePath((Binding)BindingFactory.root(), (TriplePath)tp, (ExecutionContext)execCxt);
        Stream<RDFNode> result = ((Stream)Streams.stream((Iterator)it).onClose(() -> ((QueryIterator)it).close())).map(qs -> qs.get(o)).map(arg_0 -> ((Model)model).asRDFNode(arg_0));
        return result;
    }

    public static <T extends Resource> T renameResources(T start, Class<T> clazz, Function<? super Resource, ? extends Iterator<? extends RDFNode>> listResources, Function<? super T, String> resAndHashToIri) {
        Object result = start;
        Iterator<? extends RDFNode> it = listResources.apply(start);
        while (it.hasNext()) {
            RDFNode tmpQ = it.next();
            Resource q = (Resource)tmpQ.as(clazz);
            String iri = resAndHashToIri.apply(q);
            Resource newRes = org.apache.jena.util.ResourceUtils.renameResource((Resource)q, (String)iri);
            if (!q.equals(start)) continue;
            result = (Resource)newRes.as(clazz);
        }
        return result;
    }

    public static Map<Resource, Resource> renameResources(String lsqBaseIri, Map<RDFNode, String> renames) {
        HashMap<Resource, Resource> result = new HashMap<Resource, Resource>();
        for (Map.Entry<RDFNode, String> e : renames.entrySet()) {
            String part = e.getValue();
            String iri = lsqBaseIri + part;
            RDFNode n = e.getKey();
            if (!n.isResource()) continue;
            Resource src = n.asResource();
            Resource tgt = org.apache.jena.util.ResourceUtils.renameResource((Resource)src, (String)iri);
            result.put(src, tgt);
        }
        return result;
    }

    public static StmtIterator asStmtIterator(Iterator<Triple> i, ModelCom m) {
        return new StmtIteratorImpl((Iterator)WrappedIterator.create(i).mapWith(t -> ResourceUtils.toStatement(t, m)));
    }

    public static Statement toStatement(Triple t, ModelCom eg) {
        ResourceImpl s = new ResourceImpl(t.getSubject(), eg);
        PropertyImpl p = new PropertyImpl(t.getPredicate(), (EnhGraph)eg);
        RDFNode o = ResourceUtils.createObject(t.getObject(), (EnhGraph)eg);
        return new StatementImpl((Resource)s, (Property)p, o, eg);
    }

    public static RDFNode createObject(Node n, EnhGraph g) {
        if (n.isBlank() || n.isURI()) {
            return new ResourceImpl(n, g);
        }
        if (n.isLiteral()) {
            return new LiteralImpl(n, g);
        }
        if (n.isTripleTerm()) {
            return new StatementTermImpl(n, g);
        }
        if (Node.ANY.equals((Object)n)) {
            return new ResourceImpl(n, g);
        }
        if (n.isVariable()) {
            return new ResourceImpl(n, g);
        }
        throw new JenaException("Node type not compatible with Model: " + String.valueOf(n));
    }
}

