/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.RdfBackedCollection;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class RawSetFromMappedPropertyValues
extends AbstractSet<RDFNode>
implements RdfBackedCollection<RDFNode> {
    protected Resource subject;
    protected Property property;
    protected boolean isFwd;
    protected NodeMapper<?> nodeMapper;

    public RawSetFromMappedPropertyValues(Resource subject, Property property, NodeMapper<?> nodeMapper) {
        this(subject, property, true, nodeMapper);
    }

    public RawSetFromMappedPropertyValues(Resource subject, Property property, boolean isFwd, NodeMapper<?> nodeMapper) {
        this.subject = subject;
        this.property = property;
        this.isFwd = isFwd;
        this.nodeMapper = nodeMapper;
    }

    @Override
    public boolean add(RDFNode rdfNode) {
        Node node = rdfNode.asNode();
        boolean isValid = this.nodeMapper.canMap(node);
        if (!isValid) {
            throw new IllegalArgumentException("Argument " + String.valueOf(rdfNode) + " not accepted by nodeMapper");
        }
        boolean result = ResourceUtils.addProperty((RDFNode)this.subject, this.property, this.isFwd, rdfNode);
        return result;
    }

    @Override
    public void clear() {
        ResourceUtils.setProperty(this.subject, this.property, this.isFwd, this.nodeMapper, null);
    }

    @Override
    public Iterator<RDFNode> iterator() {
        ExtendedIterator result = ResourceUtils.listProperties(this.subject, this.property, this.isFwd, this.nodeMapper).mapWith(stmt -> ResourceUtils.getTarget(stmt, this.isFwd));
        return result;
    }

    @Override
    public int size() {
        int result = Iterators.size(this.iterator());
        return result;
    }

    public Set<RDFNode> getRawCollection() {
        return new RawSetFromMappedPropertyValues(this.subject, this.property, this.isFwd, this.nodeMapper);
    }
}

