/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import java.util.Objects;
import org.aksw.jena_sparql_api.mapper.proxy.TypeDecider;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperFromTypeMapper;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperPassthrough;
import org.aksw.jena_sparql_api.rdf.collections.RDFNodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.ModelUtils;

public class RDFNodeMapperImpl<T>
implements RDFNodeMapper<T> {
    protected TypeMapper typeMapper;
    protected TypeDecider typeDecider;
    protected Class<T> viewClass;
    protected boolean polymorphicOnly;
    protected boolean enableCanAsCheck;
    protected transient NodeMapper<T> nodeMapper;

    public RDFNodeMapperImpl(Class<T> viewClass, TypeMapper typeMapper, TypeDecider typeDecider, boolean polymorphicOnly, boolean enableCanAsCheck) {
        this.typeMapper = typeMapper;
        this.typeDecider = typeDecider;
        this.viewClass = viewClass;
        this.polymorphicOnly = polymorphicOnly;
        this.enableCanAsCheck = enableCanAsCheck;
        this.nodeMapper = Node.class.isAssignableFrom(viewClass) ? new NodeMapperPassthrough() : new NodeMapperFromTypeMapper(viewClass, typeMapper);
    }

    @Override
    public boolean canMap(RDFNode rdfNode) {
        T tmp = this.toJava(rdfNode);
        boolean result = tmp != null;
        return result;
    }

    @Override
    public T toJava(RDFNode rdfNode) {
        Objects.requireNonNull(rdfNode);
        Objects.requireNonNull(this.viewClass);
        Node n = rdfNode.asNode();
        Object result = this.nodeMapper.canMap(n) ? this.nodeMapper.toJava(n) : RDFNodeMapperImpl.castRdfNode(rdfNode, this.viewClass, this.typeDecider, this.polymorphicOnly, this.enableCanAsCheck);
        return result;
    }

    public static <T extends RDFNode> T castRdfNode(RDFNode rdfNode, Class<?> viewClass, TypeDecider typeDecider, boolean polymorphicOnly, boolean enableCanAsCheck) {
        Class<?> effectiveType;
        if (rdfNode.isResource()) {
            Resource r = rdfNode.asResource();
            effectiveType = RDFNodeMapperImpl.getEffectiveType(r, viewClass, typeDecider, polymorphicOnly);
        } else {
            effectiveType = viewClass;
        }
        RDFNode result = effectiveType == null ? null : (!enableCanAsCheck || rdfNode.canAs(effectiveType) ? rdfNode.as(effectiveType) : null);
        return (T)result;
    }

    public static Class<?> getEffectiveType(Resource r, Class<?> viewClass, TypeDecider typeDecider, boolean polymorphicOnly) {
        Class<Object> effectiveType = ResourceUtils.getMostSpecificSubclass(r, viewClass, typeDecider);
        if (effectiveType == null) {
            if (viewClass.isAssignableFrom(Resource.class)) {
                effectiveType = RDFNode.class;
            } else if (Resource.class.isAssignableFrom(viewClass) && !polymorphicOnly) {
                effectiveType = viewClass;
            }
        }
        return effectiveType;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.viewClass;
    }

    @Override
    public RDFNode toNode(T obj) {
        RDFNode result;
        if (obj instanceof RDFNode) {
            Class<Object> effectiveViewClass;
            RDFNode r = (RDFNode)obj;
            Class<Object> clazz = effectiveViewClass = r.isResource() ? ResourceUtils.getMostSpecificSubclass(r.asResource(), this.viewClass, this.typeDecider) : this.viewClass;
            if (effectiveViewClass == null && !this.polymorphicOnly) {
                effectiveViewClass = this.viewClass;
            }
            Objects.requireNonNull(effectiveViewClass);
            if (effectiveViewClass.isAssignableFrom(RDFNode.class)) {
                effectiveViewClass = RDFNode.class;
            }
            result = effectiveViewClass == null ? null : r.as(effectiveViewClass);
        } else {
            Node n = (Node)this.nodeMapper.toNode(obj);
            result = ModelUtils.convertGraphNodeToRDFNode((Node)n);
        }
        return result;
    }
}

