/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aksw.commons.util.obj.ObjectUtils;
import org.aksw.commons.util.reflect.ClassUtils;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperFromRdfDatatype;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class NodeMapperFromTypeMapper<T>
implements NodeMapper<T> {
    protected TypeMapper typeMapper;
    protected Class<?> viewClass;

    public NodeMapperFromTypeMapper(Class<?> viewClass, TypeMapper typeMapper) {
        this.viewClass = viewClass;
        this.typeMapper = typeMapper;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.viewClass;
    }

    @Override
    public boolean canMap(Node node) {
        boolean result = NodeMapperFromRdfDatatype.canMapCore(node, this.viewClass);
        return result;
    }

    @Override
    public T toJava(Node node) {
        Object result = NodeMapperFromRdfDatatype.toJavaCore(node, this.viewClass);
        return result;
    }

    public static RDFDatatype findTypeMapping(TypeMapper typeMapper, Object obj) {
        RDFDatatype result = typeMapper.getTypeByValue(obj);
        if (result == null) {
            Class<?> cls = obj.getClass();
            result = NodeMapperFromTypeMapper.findInHierarchy(typeMapper, cls);
        }
        return result;
    }

    public static RDFDatatype findInHierarchy(TypeMapper typeMapper, Class<?> cls) {
        RDFDatatype result = null;
        Iterator it = ClassUtils.bfsStream(cls).iterator();
        while (it.hasNext()) {
            List breadth = (List)it.next();
            Map<Class, RDFDatatype> map = breadth.stream().map(x -> new AbstractMap.SimpleEntry<Class, RDFDatatype>((Class)x, typeMapper.getTypeByClass(x))).filter(x -> x.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (map.isEmpty()) continue;
            if (map.size() == 1) {
                result = map.values().iterator().next();
                continue;
            }
            throw new RuntimeException("Multiple candidate type mappings: " + String.valueOf(map));
        }
        return result;
    }

    @Override
    public Node toNode(T obj) {
        RDFDatatype dtype = NodeMapperFromTypeMapper.findTypeMapping(this.typeMapper, obj);
        Objects.requireNonNull(dtype, "No datatype found for object of type " + String.valueOf(ObjectUtils.getClass(obj)) + " with value " + String.valueOf(obj));
        Node result = NodeFactory.createLiteralByValue(obj, (RDFDatatype)dtype);
        return result;
    }
}

