/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.lambda.serializable.SerializablePredicate;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.apache.jena.graph.Node;

public class NodeMapperDelegating<T>
implements NodeMapper<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Class<?> javaClass;
    protected Function<? super T, Node> toNode;
    protected Function<? super Node, T> toJava;
    protected Predicate<? super Node> canMap;

    public NodeMapperDelegating(Class<?> javaClass, Predicate<? super Node> canMap, Function<? super T, Node> toNode, Function<? super Node, T> toJava) {
        this.javaClass = javaClass;
        this.canMap = canMap;
        this.toNode = toNode;
        this.toJava = toJava;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean canMap(Node node) {
        boolean result = this.canMap.test((Node)node);
        return result;
    }

    @Override
    public Node toNode(T obj) {
        Node result = this.toNode.apply(obj);
        return result;
    }

    @Override
    public T toJava(Node node) {
        T result = this.toJava.apply((Node)node);
        return result;
    }

    public static <T> NodeMapperDelegating<T> create(Class<?> javaClass, SerializablePredicate<? super Node> canMap, SerializableFunction<? super T, Node> toNode, SerializableFunction<? super Node, T> toJava) {
        return new NodeMapperDelegating<T>(javaClass, (Predicate<Node>)canMap, toNode, toJava);
    }
}

