/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.aksw.commons.collections.ConvertingList;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.vocabulary.RDF;

public class ListFromRDFList
extends AbstractList<RDFNode> {
    protected Resource s;
    protected Property p;
    protected boolean isFwd = true;

    public static RDFList getList(Resource s, Property p) {
        Resource o = ResourceUtils.getPropertyValue(s, p, true, Resource.class);
        if (o == null) {
            o = RDF.nil.inModel(s.getModel());
        }
        return (RDFList)o.as(RDFList.class);
    }

    protected RDFList getList() {
        RDFList result = ListFromRDFList.getList(this.s, this.p);
        return result;
    }

    public ListFromRDFList ensureNonNull() {
        Resource o = ResourceUtils.getPropertyValue(this.s, this.p, this.isFwd, Resource.class);
        if (o == null) {
            o = RDF.nil.inModel(this.s.getModel());
            try {
                ResourceUtils.setProperty(this.s, this.p, this.isFwd, (RDFNode)o);
            }
            catch (AddDeniedException addDeniedException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public boolean addAll(Collection<? extends RDFNode> c) {
        return this.addAll(0, c);
    }

    public ListFromRDFList(Resource subject, Property property) {
        this(subject, property, true);
    }

    public static ListFromRDFList create(Resource subject, Property property) {
        return new ListFromRDFList(subject, property);
    }

    public ListFromRDFList(Resource subject, Property property, boolean isFwd) {
        this.s = subject;
        this.p = property;
        this.isFwd = isFwd;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = o instanceof RDFNode ? this.getList().contains((RDFNode)o) : false;
        return result;
    }

    @Override
    public boolean add(RDFNode e) {
        RDFList newList = this.getList().with(e);
        ResourceUtils.setProperty(this.s, this.p, (RDFNode)newList);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends RDFNode> c) {
        return this.addAll(index, c.iterator());
    }

    @Override
    public boolean addAll(int index, Iterator<? extends RDFNode> it) {
        boolean result = it.hasNext();
        ListIterator<RDFNode> listIt = this.listIterator(index);
        while (it.hasNext()) {
            RDFNode item = it.next();
            listIt.add(item);
        }
        return result;
    }

    @Override
    public void add(int index, RDFNode element) {
        boolean useListIterator = true;
        if (useListIterator) {
            this.listIterator(index).add(element);
        } else {
            RDFList list = this.getList();
            RDFList parentCell = ListFromRDFList.findParent(list, index);
            if (parentCell == null) {
                RDFList newCell = list.cons(element);
                ResourceUtils.setProperty(this.s, this.p, (RDFNode)newCell);
            } else {
                RDFList remainder = parentCell.cons(element);
                remainder.setTail(parentCell.getTail());
                parentCell.setTail(remainder);
            }
        }
    }

    public static RDFList getParent(RDFList child) {
        Objects.requireNonNull(child);
        Resource _parent = ResourceUtils.getReversePropertyValue((Resource)child, RDF.rest);
        RDFList result = _parent == null ? null : (RDFList)_parent.as(RDFList.class);
        return result;
    }

    public static void setTail(RDFList parent, RDFList element, Resource s, Property p) {
        if (parent == null) {
            ResourceUtils.setProperty(s, p, (RDFNode)element);
        } else {
            parent.setTail(element);
        }
    }

    public static void linkParentTo(RDFList element, Resource s, Property p) {
        RDFList parent = ListFromRDFList.getParent(element);
        ListFromRDFList.setTail(parent, element, s, p);
    }

    @Override
    public RDFNode get(int index) {
        RDFList list = this.getList();
        RDFNode result = list.get(index);
        return result;
    }

    @Override
    public RDFNode set(int index, RDFNode element) {
        RDFList list = this.getList();
        RDFList item = ListFromRDFList.findElement(list, index);
        item.setHead(element);
        return element;
    }

    public static RDFList findParent(RDFList list, int index) {
        RDFList result;
        if (index == 0) {
            result = null;
        } else {
            result = list;
            int n = index - 1;
            for (int i = 0; i < n; ++i) {
                result = result.getTail();
            }
        }
        return result;
    }

    public static RDFList findElement(RDFList list, int index) {
        RDFList result = list;
        for (int i = 0; i < index; ++i) {
            result = result.getTail();
        }
        return result;
    }

    @Override
    public int size() {
        RDFList list = this.getList();
        int result = list.size();
        return result;
    }

    @Override
    public Iterator<RDFNode> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<RDFNode> listIterator(int index) {
        RDFList list = this.getList();
        RDFList parentCell = ListFromRDFList.findParent(list, index);
        RDFListIterator result = new RDFListIterator(parentCell, index);
        return result;
    }

    public RDFList newListCell(RDFNode value, Resource tail) {
        Resource cell = this.s.getModel().createResource();
        cell.addProperty(RDF.first, value);
        cell.addProperty(RDF.rest, (RDFNode)tail);
        return (RDFList)cell.as(RDFList.class);
    }

    public List<Node> asNodes() {
        Converter converter = Converter.from(FrontsNode::asNode, arg_0 -> ((Model)this.s.getModel()).asRDFNode(arg_0));
        return new ConvertingList((List)this, converter);
    }

    public class RDFListIterator
    implements ListIterator<RDFNode> {
        protected RDFList cursorCell;
        protected boolean reachedEnd = false;
        protected RDFList seenCell = null;
        protected int currentIndex;

        protected RDFListIterator(RDFList head, int currentIndex) {
            this.cursorCell = head;
            this.currentIndex = currentIndex;
        }

        @Override
        public boolean hasNext() {
            RDFList nextCell = this.getNextCell(this.cursorCell);
            return !nextCell.isEmpty();
        }

        protected RDFList getNextCell(RDFList cell) {
            RDFList result = cell == null ? ListFromRDFList.this.getList() : (cell.isEmpty() ? cell : cell.getTail());
            return result;
        }

        @Override
        public RDFNode next() {
            RDFList currentCell;
            this.seenCell = currentCell = this.getNextCell(this.cursorCell);
            if (currentCell.isEmpty()) {
                Preconditions.checkState((!this.reachedEnd ? 1 : 0) != 0, (Object)"Already at end");
                this.reachedEnd = true;
            } else {
                this.cursorCell = currentCell;
                this.reachedEnd = false;
                ++this.currentIndex;
            }
            RDFNode result = currentCell.getHead();
            return result;
        }

        @Override
        public void remove() {
            Preconditions.checkState((this.seenCell != null ? 1 : 0) != 0, (Object)"Illegal remove from list operator");
            this.cursorCell = this.cursorCell == null ? null : ListFromRDFList.getParent(this.cursorCell);
            RDFList parent = ListFromRDFList.getParent(this.seenCell);
            ListFromRDFList.setTail(parent, this.seenCell.getTail(), ListFromRDFList.this.s, ListFromRDFList.this.p);
            this.seenCell.removeProperties();
            this.seenCell = null;
        }

        protected RDFList getPreviousCell() {
            RDFList result = this.cursorCell == null ? null : (this.reachedEnd ? this.cursorCell : ListFromRDFList.getParent(this.cursorCell));
            return result;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursorCell != null;
        }

        @Override
        public RDFNode previous() {
            Preconditions.checkState((this.cursorCell != null ? 1 : 0) != 0, (Object)"Already at beginning of list");
            this.seenCell = this.cursorCell;
            RDFNode result = this.cursorCell.getHead();
            this.cursorCell = this.getPreviousCell();
            --this.currentIndex;
            this.reachedEnd = false;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.hasNext() ? this.currentIndex + 1 : this.currentIndex;
        }

        @Override
        public int previousIndex() {
            return this.hasPrevious() ? this.currentIndex - 1 : this.currentIndex;
        }

        @Override
        public void set(RDFNode e) {
            Preconditions.checkState((this.seenCell != null && !this.reachedEnd ? 1 : 0) != 0);
            this.seenCell.setHead(e);
        }

        @Override
        public void add(RDFNode e) {
            RDFList newCell;
            if (this.cursorCell == null) {
                RDFList list = ListFromRDFList.getList(ListFromRDFList.this.s, ListFromRDFList.this.p);
                newCell = list.cons(e);
                ResourceUtils.setProperty(ListFromRDFList.this.s, ListFromRDFList.this.p, (RDFNode)newCell);
                this.cursorCell = newCell;
                this.reachedEnd = this.cursorCell.getTail().equals(RDF.nil);
            } else if (this.reachedEnd) {
                newCell = ListFromRDFList.this.newListCell(e, (Resource)this.cursorCell.getTail());
                this.cursorCell.setTail(newCell);
                this.cursorCell = newCell;
            } else {
                RDFList next = this.getNextCell(this.cursorCell);
                newCell = ListFromRDFList.this.newListCell(e, (Resource)next);
                ListFromRDFList.setTail(this.cursorCell, newCell, ListFromRDFList.this.s, ListFromRDFList.this.p);
                this.cursorCell = newCell;
            }
            this.seenCell = newCell;
            ++this.currentIndex;
        }
    }
}

