/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.NiceIterator;

public class ForwardingIteratorWithForcedRemoval<T>
implements ClosableIterator<T> {
    protected Iterator<T> originalDelegate;
    protected Iterator<T> effectiveDelegate;
    protected Consumer<T> forceRemover;
    protected boolean delegateRemoval;
    protected boolean isNextCalled = false;
    protected T currentItem;

    public ForwardingIteratorWithForcedRemoval(Iterator<T> delegate, Consumer<T> forceRemover) {
        this(delegate, forceRemover, true);
    }

    public ForwardingIteratorWithForcedRemoval(Iterator<T> delegate, Consumer<T> forceRemover, boolean delegateRemoval) {
        this.originalDelegate = delegate;
        this.effectiveDelegate = delegate;
        this.forceRemover = forceRemover;
        this.delegateRemoval = delegateRemoval;
    }

    public boolean hasNext() {
        boolean result = this.effectiveDelegate.hasNext();
        return result;
    }

    public T next() {
        this.isNextCalled = true;
        this.currentItem = this.effectiveDelegate.next();
        return this.currentItem;
    }

    public void remove() {
        if (this.delegateRemoval) {
            try {
                this.effectiveDelegate.remove();
            }
            catch (UnsupportedOperationException e) {
                ArrayList prefetchedItems = Lists.newArrayList(this.effectiveDelegate);
                this.effectiveDelegate = prefetchedItems.iterator();
                this.delegateRemoval = false;
            }
        }
        if (!this.delegateRemoval) {
            if (!this.isNextCalled) {
                throw new IllegalStateException("Must call .next() in order to obtain a valid currentItem before calling .remove()");
            }
            this.isNextCalled = false;
            this.forceRemover.accept(this.currentItem);
        }
    }

    public void close() {
        NiceIterator.close(this.originalDelegate);
    }
}

