/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rdf.collections;

import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperDelegating;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperFromRdfDatatype;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperPassthrough;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperUriOrString;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class NodeMappers {
    public static final NodeMapper<Node> PASSTHROUGH = new NodeMapperPassthrough();
    public static final NodeMapper<String> string = NodeMappers.from(String.class);
    public static final NodeMapper<Long> xlong = NodeMappers.from(Long.class);
    public static final NodeMapper<String> DEFAULT_URI_OR_STRING = new NodeMapperUriOrString(str -> str.startsWith("file:") || UrlValidator.getInstance().isValid(str));
    public static final NodeMapper<String> uriString = new NodeMapperDelegating<String>(String.class, Node::isURI, NodeFactory::createURI, Node::getURI);

    public static <T> NodeMapper<T> fromDatatypeIri(String datatypeIri) {
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype dtype = typeMapper.getSafeTypeByName(datatypeIri);
        NodeMapperFromRdfDatatype result = new NodeMapperFromRdfDatatype(dtype);
        return result;
    }

    public static <T> NodeMapper<T> from(Class<T> clazz) {
        TypeMapper typeMapper = TypeMapper.getInstance();
        NodeMapper<T> result = NodeMappers.from(clazz, typeMapper);
        return result;
    }

    public static <T> NodeMapper<T> from(Class<T> clazz, TypeMapper typeMapper) {
        RDFDatatype dtype = typeMapper.getTypeByClass(clazz);
        NodeMapperFromRdfDatatype result = new NodeMapperFromRdfDatatype(dtype);
        return result;
    }
}

