/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.util.tdbstreamquery;

import arq.cmdline.ModDataset;
import arq.query;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aksw.jenax.stmt.resultset.SPARQLResultEx;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.TerminationException;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNull;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.Txn;
import tdb2.cmdline.CmdTDB;
import tdb2.cmdline.ModTDBDataset;

class tdbstreamquery
extends query {
    static Map<ResultsFormat, Lang> resultsFormatToLangMap = new HashMap<ResultsFormat, Lang>();

    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbstreamquery(argv).mainRun();
    }

    protected ModDataset setModDataset() {
        return new ModTDBDataset();
    }

    protected String getSummary() {
        return this.getCommandName() + " --loc=<path> --query=<query>";
    }

    protected static Lang convert(ResultsFormat fmt) {
        Lang lang = ResultsFormat.convert((ResultsFormat)fmt);
        if (lang != null) {
            return lang;
        }
        return resultsFormatToLangMap.get(fmt);
    }

    protected void queryExec(boolean timed, ResultsFormat fmt, PrintStream resultsDest) {
        Context cxt = null;
        try {
            Dataset dataset;
            Query query2 = this.getQuery();
            Lang lang = tdbstreamquery.defaultLang(tdbstreamquery.convert(fmt), query2);
            if (this.isVerbose()) {
                IndentedWriter out = new IndentedWriter((OutputStream)resultsDest, true);
                query2.serialize(out);
                out.setLineNumbers(false);
                out.println();
                out.flush();
            }
            if (this.isQuiet()) {
                LogCtl.setError((String)"org.apache.jena.riot");
            }
            if ((dataset = this.getDataset(query2)) == null && !query2.hasDatasetDescription()) {
                System.err.println("Dataset not specified in query nor provided on command line.");
                throw new TerminationException(1);
            }
            TransactionalNull transactional = dataset != null && dataset.supportsTransactions() ? dataset : new TransactionalNull();
            Txn.executeRead((Transactional)transactional, () -> {
                this.modTime.startTimer();
                try (QueryExecution qe = QueryExecutionFactory.create((Query)query2, (Dataset)dataset);){
                    SPARQLResultEx sr = SparqlStmtUtils.execAny((QueryExecution)qe, (Query)query2);
                    ResultSetWriterFactory rsWriterFactory = ResultSetWriterRegistry.getFactory((Lang)lang);
                    if (rsWriterFactory != null) {
                        ResultSetWriter rsWriter = rsWriterFactory.create(lang);
                        if (sr.isBoolean()) {
                            boolean v = sr.getBooleanResult();
                            rsWriter.write((OutputStream)System.out, v, cxt);
                        } else {
                            rsWriter.write((OutputStream)System.out, sr.getResultSet(), cxt);
                        }
                    } else if (StreamRDFWriter.registered((Lang)lang)) {
                        StreamRDF writer = StreamRDFWriter.getWriterStream((OutputStream)System.out, (Lang)lang, (Context)cxt);
                        writer.start();
                        if (sr.isQuads()) {
                            StreamRDFOps.sendQuadsToStream((Iterator)sr.getQuads(), (StreamRDF)writer);
                        } else if (sr.isTriples()) {
                            StreamRDFOps.sendTriplesToStream((Iterator)sr.getTriples(), (StreamRDF)writer);
                        }
                        writer.finish();
                    } else {
                        throw new CmdException("Could not handle execution of query " + String.valueOf(query2) + " with lang " + String.valueOf(lang));
                    }
                    long time = this.modTime.endTimer();
                    if (timed) {
                        this.totalTime += time;
                        System.err.println("Time: " + this.modTime.timeStr(time) + " sec");
                    }
                }
                catch (ResultSetException ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace(System.err);
                }
                catch (QueryException qEx) {
                    throw new CmdException("Query Exeception", (Throwable)qEx);
                }
            });
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
        catch (CmdException | JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Exception", (Throwable)ex);
        }
    }

    static Lang defaultLang(Lang lang, Query query2) {
        if (lang != null) {
            return lang;
        }
        if (query2.isConstructQuad()) {
            return Lang.NQUADS;
        }
        if (query2.isConstructType()) {
            return Lang.NTRIPLES;
        }
        if (query2.isJsonType()) {
            return Lang.RDFJSON;
        }
        return ResultSetLang.RS_JSON;
    }

    public tdbstreamquery(String[] argv) {
        super(argv);
    }

    static {
        resultsFormatToLangMap.put(ResultsFormat.FMT_RDF_XML, Lang.RDFXML);
        resultsFormatToLangMap.put(ResultsFormat.FMT_RDF_N3, Lang.N3);
        resultsFormatToLangMap.put(ResultsFormat.FMT_RDF_TTL, Lang.TURTLE);
        resultsFormatToLangMap.put(ResultsFormat.FMT_RDF_NT, Lang.NTRIPLES);
        resultsFormatToLangMap.put(ResultsFormat.FMT_RDF_JSONLD, Lang.JSONLD);
        resultsFormatToLangMap.put(ResultsFormat.FMT_RDF_NQ, Lang.NQUADS);
        resultsFormatToLangMap.put(ResultsFormat.FMT_RDF_TRIG, Lang.TRIG);
    }
}

