/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jena_sparql_api.algebra.transform.SubstitutionStrategy;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformReplaceConstants
extends TransformCopy {
    protected Generator<Var> generator;
    protected BiFunction<Node, Integer, SubstitutionStrategy> testTransform;

    public TransformReplaceConstants(Generator<Var> generator) {
        this(generator, null);
    }

    public TransformReplaceConstants(Generator<Var> generator, BiFunction<Node, Integer, SubstitutionStrategy> testTransform) {
        this.generator = generator;
        this.testTransform = testTransform;
    }

    public static Op transform(Op op, Predicate<Node> testTransform) {
        return TransformReplaceConstants.transform(op, (Node x, Integer i) -> {
            boolean tmp = testTransform.test((Node)x);
            SubstitutionStrategy r = tmp ? SubstitutionStrategy.SUBSTITUTE_AND_FILTER : SubstitutionStrategy.RETAIN;
            return r;
        });
    }

    public static Op transform(Op op, BiFunction<Node, Integer, SubstitutionStrategy> testTransform) {
        Collection mentionedVars = OpVars.mentionedVars((Op)op);
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create((String)"v", (Collection)mentionedVars);
        TransformReplaceConstants transform = new TransformReplaceConstants((Generator<Var>)gen, testTransform);
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public static Op transform(Op op, SubstitutionStrategy defaultGraphSubstitutionStrategy) {
        BiFunction<Node, Integer, SubstitutionStrategy> testTransform = (node, i) -> {
            SubstitutionStrategy r = i == 3 && Quad.isDefaultGraph((Node)node) ? defaultGraphSubstitutionStrategy : SubstitutionStrategy.SUBSTITUTE_AND_FILTER;
            return r;
        };
        Op result = TransformReplaceConstants.transform(op, testTransform);
        return result;
    }

    public static Op transform(Op op) {
        return TransformReplaceConstants.transform(op, SubstitutionStrategy.SUBSTITUTE);
    }

    public static Map<Node, Var> transform(Map<Node, Var> nodeToVar, Iterable<Node> inNodes, Generator<Var> generator) {
        LinkedHashMap<Node, Var> result = new LinkedHashMap<Node, Var>();
        for (Node node : inNodes) {
            Node n = TransformReplaceConstants.transform(nodeToVar, node, generator, null, SubstitutionStrategy.SUBSTITUTE_AND_FILTER);
            if (!n.isVariable() || n.equals((Object)node)) continue;
            result.put(node, (Var)n);
        }
        return result;
    }

    public static Node transform(Map<Node, Var> nodeToVar, Node node, Generator<Var> generator, ExprList filters, SubstitutionStrategy strategy) {
        Node result;
        if (node.isConcrete() && strategy.isSubstitute()) {
            Var var = nodeToVar.get(node);
            if (var == null) {
                var = (Var)generator.next();
                nodeToVar.put(node, var);
                if (filters != null && strategy.isInjectFilter()) {
                    E_Equals condition = new E_Equals((Expr)new ExprVar(var), (Expr)NodeValue.makeNode((Node)node));
                    filters.add((Expr)condition);
                }
            }
            result = var;
        } else {
            result = node;
        }
        return result;
    }

    public Op transform(OpBGP opBGP) {
        Set newVisibleVars;
        Set oldVisibleVars;
        HashMap<Node, Var> nodeToVar = new HashMap<Node, Var>();
        ExprList filters = new ExprList();
        List ts = opBGP.getPattern().getList();
        BasicPattern triples = this.transform(ts, nodeToVar, filters);
        OpBGP result = new OpBGP(triples);
        if (!filters.isEmpty()) {
            result = OpFilter.filterBy((ExprList)filters, (Op)result);
        }
        if (!(oldVisibleVars = OpVars.visibleVars((Op)opBGP)).equals(newVisibleVars = OpVars.visibleVars((Op)result))) {
            result = new OpProject((Op)result, new ArrayList(oldVisibleVars));
        }
        return result;
    }

    public BasicPattern transform(Collection<Triple> ts, Map<Node, Var> nodeToVar, ExprList filters) {
        BasicPattern triples = new BasicPattern();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Triple triple : ts) {
            List tmp = TripleUtils.tripleToList((Triple)triple);
            for (int i = 0; i < tmp.size(); ++i) {
                Node node = (Node)tmp.get(i);
                SubstitutionStrategy strategy = this.testTransform.apply(node, i);
                Node n = TransformReplaceConstants.transform(nodeToVar, node, this.generator, filters, strategy);
                nodes.add(n);
            }
            Triple t = TripleUtils.listToTriple(nodes);
            triples.add(t);
            nodes.clear();
        }
        return triples;
    }

    public Op transform(OpQuadPattern op) {
        Set newVisibleVars;
        Set oldVisibleVars;
        HashMap<Node, Var> nodeToVar = new HashMap<Node, Var>();
        ExprList filters = new ExprList();
        Node gn = op.getGraphNode();
        SubstitutionStrategy strategy = this.testTransform.apply(gn, 3);
        Node graphNode = TransformReplaceConstants.transform(nodeToVar, gn, this.generator, filters, strategy);
        List ts = op.getBasicPattern().getList();
        BasicPattern triples = this.transform(ts, nodeToVar, filters);
        OpQuadPattern result = new OpQuadPattern(graphNode, triples);
        if (!filters.isEmpty()) {
            result = OpFilter.filterBy((ExprList)filters, (Op)result);
        }
        if (!(oldVisibleVars = OpVars.visibleVars((Op)op)).equals(newVisibleVars = OpVars.visibleVars((Op)result))) {
            result = new OpProject((Op)result, new ArrayList(oldVisibleVars));
        }
        return result;
    }
}

