/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.aksw.jenax.arq.util.expr.CnfUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformRedundantFilterRemoval
extends TransformCopy {
    public static Op transform(Op op) {
        TransformRedundantFilterRemoval transform = new TransformRedundantFilterRemoval();
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        Object result;
        if (subOp instanceof OpExtend) {
            OpExtend so = (OpExtend)subOp;
            VarExprList vel = so.getVarExprList();
            Map map = vel.getExprs();
            Set cnf = CnfUtils.toSetCnf((ExprList)opFilter.getExprs());
            boolean modified = false;
            LinkedHashSet<Set> newCnf = new LinkedHashSet<Set>();
            for (Set clause : cnf) {
                boolean modifiedClause = false;
                if (clause.size() == 1) {
                    Map.Entry vc;
                    Expr expr = (Expr)clause.iterator().next();
                    if (expr instanceof E_OneOf) {
                        Var var;
                        Expr def;
                        E_OneOf eoo = (E_OneOf)expr;
                        Expr lhs = eoo.getLHS();
                        if (lhs.isVariable() && (def = (Expr)map.get(var = lhs.asVar())) != null) {
                            ExprList args = eoo.getRHS();
                            boolean isTrue = args.getList().contains(def);
                            if (isTrue) {
                                modifiedClause = true;
                            } else if (def.isConstant()) {
                                ExprList newArgs = new ExprList();
                                for (Expr arg : args) {
                                    if (arg.isConstant()) continue;
                                    newArgs.add(arg);
                                }
                                if (newArgs.size() != args.size()) {
                                    modifiedClause = true;
                                    if (!newArgs.isEmpty()) {
                                        E_OneOf newExpr = new E_OneOf(lhs, newArgs);
                                        newCnf.add(Collections.singleton(newExpr));
                                    } else {
                                        newCnf.add(Collections.singleton(NodeValue.FALSE));
                                    }
                                }
                            }
                        }
                    } else if (expr instanceof E_Equals && (vc = ExprUtils.extractVarConstant((Expr)expr)) != null && Objects.equals(map.get(vc.getKey()), vc.getValue())) {
                        modifiedClause = true;
                    }
                }
                if (!modifiedClause) {
                    newCnf.add(clause);
                }
                modified = modified || modifiedClause;
            }
            result = modified ? (newCnf.isEmpty() ? subOp : OpFilter.filter((Expr)CnfUtils.toExpr(newCnf), (Op)subOp)) : opFilter;
        } else {
            result = opFilter;
        }
        return result;
    }
}

