/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.List;
import java.util.function.BiFunction;
import org.aksw.jenax.arq.util.query.TransformCopyAdapter;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.engine.main.OpExecutor;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public class TransformEvalTable
extends TransformCopyAdapter {
    protected OpExecutor opExecutor;
    protected ExecutionContext execCxt;

    public TransformEvalTable(OpExecutor opExecutor, ExecutionContext execCxt) {
        this.opExecutor = opExecutor;
        this.execCxt = execCxt;
    }

    public static TransformEvalTable create() {
        OpExecutorFactory opExecutorFactory = OpExecutor.stdFactory;
        ExecutionContext execCxt = TransformEvalTable.createExecCxt(opExecutorFactory);
        OpExecutor opExecutor = opExecutorFactory.create(execCxt);
        return new TransformEvalTable(opExecutor, execCxt);
    }

    public static ExecutionContext createExecCxt(OpExecutorFactory opExecutorFactory) {
        Context cxt = ARQ.getContext().copy();
        cxt.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        DatasetGraph dataset = DatasetGraphFactory.create();
        ExecutionContext execCxt = new ExecutionContext(cxt, dataset.getDefaultGraph(), dataset, opExecutorFactory);
        return execCxt;
    }

    public OpTable exec(Op op) {
        QueryIterator queryIter = this.opExecutor.executeOp(op, QueryIterRoot.create((ExecutionContext)this.execCxt));
        TableN table = new TableN(queryIter);
        return OpTable.create((Table)table);
    }

    protected <OPN extends OpN> Op transformOpN(OPN op, List<Op> subOps, BiFunction<? super OPN, ? super List<Op>, ? extends Op> fallback) {
        Op result;
        boolean isAllTables = subOps.stream().allMatch(subOp -> subOp instanceof OpTable);
        if (isAllTables) {
            OpN tmp = op.copy(subOps);
            result = this.exec((Op)tmp);
        } else {
            result = fallback.apply(op, subOps);
        }
        return result;
    }

    protected <OP2 extends Op2> Op transformOp2(OP2 op, Op left, Op right, TransformCopyAdapter.TriFunction<? super OP2, ? super Op, ? super Op, ? extends Op> fallback) {
        Op result;
        if (left instanceof OpTable && right instanceof OpTable) {
            Op2 tmp = op.copy(left, right);
            result = this.exec((Op)tmp);
        } else {
            result = (Op)fallback.apply(op, (Object)left, (Object)right);
        }
        return result;
    }

    protected <OP1 extends Op1> Op transformOp1(OP1 op, Op subOp, BiFunction<? super OP1, ? super Op, ? extends Op> fallback) {
        Op result = null;
        if (subOp instanceof OpTable) {
            Op1 tmp = op.copy(subOp);
            result = this.exec((Op)tmp);
        } else {
            result = fallback.apply(op, (Op)subOp);
        }
        return result;
    }
}

