/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.List;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprVar;

public class TransformDatasetNamesViaSpo
extends TransformCopy {
    public Op transform(OpGraph opGraph, Op subOp) {
        Op result = OpUtils.isUnitTable(subOp) ? TransformDatasetNamesViaSpo.createGraphNamesOp(opGraph.getNode()) : super.transform(opGraph, subOp);
        return result;
    }

    public Op transform(OpDatasetNames opDatasetNames) {
        Node g = opDatasetNames.getGraphNode();
        Op result = TransformDatasetNamesViaSpo.createGraphNamesOp(g);
        return result;
    }

    public static Op createGraphNamesOp(Node graphNode) {
        Var gv = graphNode.isVariable() ? (Var)graphNode : Vars.g;
        Var s = Vars.s;
        Var p = Vars.p;
        Var o = Vars.o;
        OpDistinct result = new OpDistinct((Op)new OpProject((Op)new OpGraph((Node)gv, (Op)new OpBGP(BasicPattern.wrap(List.of(Triple.create((Node)s, (Node)p, (Node)o))))), List.of(gv)));
        if (!graphNode.isVariable()) {
            Op condition = OpFilter.filter((Expr)new E_Equals((Expr)new ExprVar(gv), ExprLib.nodeToExpr((Node)graphNode)), (Op)result);
            result = OpFilter.filter((Expr)new E_Exists(condition), (Op)OpTable.unit());
        }
        return result;
    }

    public static void main(String[] args) {
        String queryStr = "SELECT * { GRAPH ?g { } }";
        System.out.println(QueryUtils.applyOpTransform((Query)QueryFactory.create((String)queryStr), op -> Transformer.transform((Transform)new TransformDatasetNamesViaSpo(), (Op)op)));
    }
}

