/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.algebra.eval;

import java.util.Collection;
import java.util.Map;
import org.aksw.jenax.constraint.api.CBinding;
import org.aksw.jenax.constraint.api.VSpace;
import org.aksw.jenax.constraint.impl.CBindingMap;
import org.aksw.jenax.constraint.util.ConstraintDerivations;
import org.aksw.jenax.sparql.algebra.eval.EvaluationDispatch;
import org.aksw.jenax.sparql.algebra.eval.EvaluatorBase;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class EvaluationOfConstraints
extends EvaluatorBase<CBinding> {
    public EvaluationOfConstraints() {
        this.dispatcher = new EvaluationDispatch<CBinding>(this);
    }

    public static void main(String[] args) {
        Query query = QueryFactory.create((String)"SELECT ?x { { ?s ?p ?o } UNION {SELECT ?x { ?s ?p ?o BIND(IRI(CONCAT('foo', ?bar)) AS ?x) } } } ORDER By ?p");
        Op op = Algebra.compile((Query)query);
        System.out.println(op);
        EvaluationOfConstraints evaluator = new EvaluationOfConstraints();
        CBinding tmp = evaluator.evalOp(op, CBindingMap.create());
        System.out.println(tmp);
    }

    @Override
    public CBinding eval(OpBGP op, CBinding input) {
        CBinding result = CBindingMap.create();
        for (Triple triple : op.getPattern().getList()) {
            ConstraintDerivations.deriveConstraints((CBinding)result, (Triple)triple);
        }
        return result;
    }

    @Override
    public CBinding eval(OpQuadPattern op, CBinding input) {
        CBinding result = CBindingMap.create();
        for (Quad quad : op.getPattern().getList()) {
            ConstraintDerivations.deriveConstraints((CBinding)result, (Quad)quad);
        }
        return result;
    }

    @Override
    public CBinding eval(OpFilter op, CBinding input) {
        CBinding result = this.evalOp(op.getSubOp(), input);
        return result;
    }

    @Override
    public CBinding eval(OpJoin op, CBinding input) {
        CBinding left = this.eval(op.getLeft(), input);
        CBinding right = this.eval(op.getRight(), left);
        CBinding result = left.cloneObject();
        result.stateIntersection(right);
        return result;
    }

    @Override
    public CBinding eval(OpUnion op, CBinding input) {
        CBinding left = this.eval(op.getLeft(), input);
        CBinding right = this.eval(op.getRight(), input);
        CBinding result = left.cloneObject().stateUnion(right);
        return result;
    }

    @Override
    public CBinding eval(OpSlice op, CBinding input) {
        CBinding result = this.eval(op.getSubOp(), input);
        return result;
    }

    @Override
    public CBinding eval(OpProject op, CBinding input) {
        CBinding base = this.eval(op.getSubOp(), input);
        CBinding result = base.cloneObject().project((Collection)op.getVars());
        return result;
    }

    @Override
    public CBinding eval(OpOrder op, CBinding input) {
        CBinding result = this.eval(op.getSubOp(), input);
        return result;
    }

    @Override
    public CBinding eval(OpDistinct op, CBinding input) {
        CBinding result = this.eval(op.getSubOp(), input);
        return result;
    }

    @Override
    public CBinding eval(OpReduced op, CBinding input) {
        CBinding result = this.eval(op.getSubOp(), input);
        return result;
    }

    @Override
    public CBinding eval(OpService opService, CBinding input) {
        return CBindingMap.create();
    }

    @Override
    public CBinding eval(OpGroup op, CBinding input) {
        CBinding result = this.eval(op.getSubOp(), input);
        return result;
    }

    @Override
    public CBinding eval(OpGraph op, CBinding input) {
        CBinding result = this.eval(op.getSubOp(), input);
        return result;
    }

    @Override
    public CBinding eval(OpExtend op, CBinding input) {
        CBinding tmp = this.eval(op.getSubOp(), input);
        if (tmp == null) {
            System.err.println("WARN: sub op evaluated to null");
        }
        CBinding result = tmp.cloneObject();
        for (Map.Entry entry : op.getVarExprList().getExprs().entrySet()) {
            Var v = (Var)entry.getKey();
            Expr e = (Expr)entry.getValue();
            VSpace vc = ConstraintDerivations.deriveValueSpace((Expr)e, (CBinding)result);
            result.stateIntersection(v, vc);
        }
        return result;
    }
}

