/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.expr.transform;

import com.google.common.collect.Maps;
import java.util.Map;
import org.aksw.commons.util.function.FixpointIteration;
import org.aksw.jena_sparql_api.algebra.transform.TransformExprToBasicPattern;
import org.aksw.jena_sparql_api.algebra.transform.TransformPullFiltersIfCanMergeBGPs;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.TransformMergeBGPs;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprTransformMacroExpansion {
    protected Map<String, UserDefinedFunctionDefinition> macros;
    protected Map<String, Boolean> propertyFunctions;
    private static final Logger logger = LoggerFactory.getLogger(ExprTransformMacroExpansion.class);

    public ExprTransformMacroExpansion(Map<String, UserDefinedFunctionDefinition> macros, Map<String, Boolean> propertyFunctions) {
        this.macros = macros;
        this.propertyFunctions = propertyFunctions;
    }

    public Op rewrite(Op op) {
        Op c = op;
        Op d = TransformExprToBasicPattern.transform(c, fn -> {
            String id = ExprUtils.getFunctionId((ExprFunction)fn.getFunction());
            Boolean subjectAsOutput = this.propertyFunctions.get(id);
            Map.Entry r = subjectAsOutput == null ? null : Maps.immutableEntry((Object)id, (Object)subjectAsOutput);
            return r;
        });
        Op e = (Op)FixpointIteration.apply((Object)d, x -> {
            x = TransformPullFiltersIfCanMergeBGPs.transform(x);
            x = Transformer.transform((Transform)new TransformMergeBGPs(), (Op)x);
            return x;
        });
        return e;
    }

    public Query rewrite(Query query) {
        Query result = QueryUtils.rewrite((Query)query, this::rewrite);
        logger.debug("Rewrote query\n" + String.valueOf(query) + " to\n" + String.valueOf(result));
        return result;
    }
}

