/*
 * Decompiled with CFR 0.152.
 */
package com.eccenca.access_control.triple_based.core;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import org.aksw.commons.collections.PolaritySet;
import org.aksw.jenax.arq.util.expr.ExprListUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElementTransformTripleBasedRewrite
extends ElementTransformCopyBase {
    private static final Logger logger = LoggerFactory.getLogger(ElementTransformTripleBasedRewrite.class);

    public abstract Element applyTripleTransform(Triple var1);

    public abstract Element applyTriplePathTransform(TriplePath var1);

    public static Expr valueSetToExpr(PolaritySet<Node> valueSet, Var var) {
        ExprList el = ExprListUtils.nodesToExprs((Iterable)valueSet.getValue());
        E_OneOf core = new E_OneOf((Expr)new ExprVar(var), el);
        E_OneOf result = valueSet.isPositive() ? core : new E_LogicalNot((Expr)core);
        return result;
    }

    public Element transform(ElementTriplesBlock el) {
        BasicPattern bgp = el.getPattern();
        BasicPattern newPattern = new BasicPattern();
        ArrayList<Element> elements = new ArrayList<Element>(bgp.size());
        for (Triple triple : bgp) {
            Element e = this.applyTripleTransform(triple);
            if (e == null) {
                newPattern.add(triple);
                continue;
            }
            elements.add(e);
        }
        ArrayList<Element> items = newPattern.isEmpty() ? elements : Iterables.concat(Collections.singleton(new ElementTriplesBlock(newPattern)), elements);
        ElementGroup result = ElementUtils.createElementGroup(items);
        return result;
    }

    public Element transform(ElementPathBlock el) {
        PathBlock bgp = el.getPattern();
        ElementPathBlock newPattern = new ElementPathBlock();
        ArrayList<Element> elements = new ArrayList<Element>(bgp.size());
        for (TriplePath tp : bgp) {
            Element e;
            if (tp.isTriple()) {
                Triple triple = tp.asTriple();
                e = this.applyTripleTransform(triple);
                if (e == null) {
                    newPattern.addTriple(new TriplePath(triple));
                    continue;
                }
                elements.add(e);
                continue;
            }
            e = this.applyTriplePathTransform(tp);
            if (e == null) {
                newPattern.addTriple(tp);
                continue;
            }
            elements.add(e);
        }
        ArrayList<Element> items = newPattern.isEmpty() ? elements : Iterables.concat(Collections.singleton(newPattern), elements);
        ElementGroup result = ElementUtils.createElementGroup(items);
        return result;
    }
}

