/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.algebra.transform.ProjectExtend;
import org.aksw.jena_sparql_api.algebra.transform.TransformPullFiltersIfCanMergeBGPs;
import org.aksw.jenax.arq.util.syntax.VarExprListUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.optimize.TransformExtendCombine;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;

public class TransformPullExtend
extends TransformExtendCombine {
    public static Op transform(Op op) {
        TransformPullExtend transform = new TransformPullExtend();
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public Op transform(OpDisjunction opDisjunction, List<Op> elts) {
        Op result = this.transformDisjunction(elts, list -> OpUnion.create((Op)((Op)list.get(0)), (Op)((Op)list.get(1))));
        if (result == null) {
            result = super.transform(opDisjunction, elts);
        }
        return result;
    }

    public Op transform(OpUnion opUnion, Op left, Op right) {
        Op result = this.transformDisjunction(Arrays.asList(left, right), list -> OpUnion.create((Op)((Op)list.get(0)), (Op)((Op)list.get(1))));
        if (result == null) {
            result = super.transform(opUnion, left, right);
        }
        return result;
    }

    public Op transform(OpProject opProject, Op subOp) {
        Op result;
        if (subOp instanceof OpProject) {
            OpProject o = (OpProject)subOp;
            HashSet vars = new HashSet(o.getVars());
            List newVars = opProject.getVars().stream().filter(vars::contains).collect(Collectors.toList());
            result = new OpProject(o.getSubOp(), newVars);
        } else {
            result = super.transform(opProject, subOp);
        }
        return result;
    }

    public Op transformDisjunction(List<Op> subOps, Function<List<Op>, Op> toUnion) {
        boolean allMembersProcessable;
        Op result = null;
        VarExprList common = new VarExprList();
        List pes = subOps.stream().map(ProjectExtend::collect).collect(Collectors.toList());
        boolean bl = allMembersProcessable = !pes.stream().anyMatch(Objects::isNull);
        if (allMembersProcessable) {
            Set candidatePullableVars = pes.stream().map(ProjectExtend::getPullableVars).flatMap(Collection::stream).collect(Collectors.toSet());
            HashSet<Object> rejectedCandidateVars = new HashSet<Object>();
            block0: for (Object var : candidatePullableVars) {
                boolean isPriorSet = false;
                Expr prior = null;
                for (ProjectExtend pe : pes) {
                    Expr expr = pe.getVel().getExpr((Var)var);
                    if (!isPriorSet) {
                        isPriorSet = true;
                        prior = expr;
                        continue;
                    }
                    if (Objects.equals(prior, expr)) continue;
                    rejectedCandidateVars.add(var);
                    continue block0;
                }
                if (prior == null) continue;
                common.add((Var)var, prior);
            }
            if (!common.isEmpty()) {
                ArrayList<Op> newOps = new ArrayList<Op>(subOps.size());
                for (ProjectExtend pe : pes) {
                    ArrayList<Var> nonPullableVars = new ArrayList<Var>(pe.getNonPullableVars());
                    nonPullableVars.addAll(rejectedCandidateVars);
                    VarExprList nonPullableVel = VarExprListUtils.projectAllVars((VarExprList)pe.getVel(), nonPullableVars);
                    Op newInnerOp = ProjectExtend.applyIfNeeded(pe.getProject() != null, nonPullableVel, pe.getSubOp());
                    newOps.add(newInnerOp);
                }
                Op newDisjunction = toUnion.apply(newOps);
                VarExprList pullable = VarExprListUtils.projectAllVars((VarExprList)common, (Collection)common.getVars());
                result = ProjectExtend.applyIfNeeded(false, pullable, newDisjunction);
            }
        }
        return result;
    }

    public Op transform(OpLateral op, Op left, Op right) {
        ProjectExtend peRight = ProjectExtend.collect(right);
        Op result = null;
        if (peRight != null) {
            OpExtend o;
            VarExprList nonPullable = VarExprListUtils.projectAllVars((VarExprList)peRight.getVel(), peRight.getNonPullableVars());
            Op newInnerRight = ProjectExtend.applyIfNeeded(peRight.getProject() != null, nonPullable, peRight.getSubOp());
            if (newInnerRight instanceof OpExtend && OpJoin.isJoinIdentify((Op)(o = (OpExtend)newInnerRight).getSubOp())) {
                OpExtend newLateral = OpExtend.create((Op)left, (VarExprList)o.getVarExprList());
                VarExprList pullable = VarExprListUtils.projectAllVars((VarExprList)peRight.getVel(), peRight.getPullableVars());
                result = ProjectExtend.apply(peRight.getProject(), pullable, (Op)newLateral);
            }
            if (result == null) {
                Op newLateral = OpLateral.create((Op)left, (Op)newInnerRight);
                VarExprList pullable = VarExprListUtils.projectAllVars((VarExprList)peRight.getVel(), peRight.getPullableVars());
                result = ProjectExtend.apply(peRight.getProject(), pullable, newLateral);
            }
        } else {
            result = super.transform(op, left, right);
        }
        return result;
    }

    public Op transform(OpSlice op, Op subOp) {
        ProjectExtend pe = ProjectExtend.collect(subOp);
        Op result = pe != null ? pe.apply((Op)new OpSlice(pe.getSubOp(), op.getStart(), op.getLength())) : super.transform(op, subOp);
        return result;
    }

    public Op transform(OpDistinct op, Op subOp) {
        Op result;
        ProjectExtend pe = ProjectExtend.collect(subOp);
        if (pe != null && !pe.getPullableVars().isEmpty()) {
            VarExprList nonPullable = VarExprListUtils.projectAllVars((VarExprList)pe.getVel(), pe.getNonPullableVars());
            Op newInnerOp = ProjectExtend.applyIfNeeded(pe.getProject() != null, nonPullable, pe.getSubOp());
            Op newDistinct = OpDistinct.create((Op)newInnerOp);
            VarExprList pullable = VarExprListUtils.projectAllVars((VarExprList)pe.getVel(), pe.getPullableVars());
            result = ProjectExtend.apply(pe.getProject(), pullable, newDistinct);
        } else {
            result = super.transform(op, subOp);
        }
        return result;
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList el;
        Set usedVars;
        OpExtend e;
        VarExprList vel;
        Set extendVars;
        Sets.SetView conflicts;
        Op result = null;
        if (subOp instanceof OpExtend && (conflicts = Sets.intersection((Set)(extendVars = VarExprListUtils.getVarsMentioned((VarExprList)(vel = (e = (OpExtend)subOp).getVarExprList()))), (Set)(usedVars = (el = opFilter.getExprs()).getVarsMentioned()))).isEmpty()) {
            boolean containsSpecialVars;
            boolean bl = containsSpecialVars = TransformPullFiltersIfCanMergeBGPs.containsSpecialVar(extendVars) || TransformPullFiltersIfCanMergeBGPs.containsSpecialVar(usedVars);
            if (!containsSpecialVars) {
                result = OpExtend.create((Op)OpFilter.filterBy((ExprList)el, (Op)e.getSubOp()), (VarExprList)vel);
            }
        }
        if (result == null) {
            result = super.transform(opFilter, subOp);
        }
        return result;
    }

    public Op transform(OpJoin opJoin, Op left, Op right) {
        Op result;
        VarExprList velRight;
        OpExtend ol = left instanceof OpExtend ? (OpExtend)left : null;
        OpExtend or = right instanceof OpExtend ? (OpExtend)right : null;
        VarExprList velLeft = ol != null ? ol.getVarExprList() : null;
        VarExprList varExprList = velRight = or != null ? or.getVarExprList() : null;
        if (velLeft != null && velRight != null) {
            Sets.SetView conflicts = Sets.intersection(new LinkedHashSet(velLeft.getVars()), new LinkedHashSet(velRight.getVars()));
            if (conflicts.isEmpty()) {
                VarExprList combined = new VarExprList();
                combined.addAll(velLeft);
                combined.addAll(velRight);
                result = OpExtend.extend((Op)OpJoin.create((Op)ol.getSubOp(), (Op)or.getSubOp()), (VarExprList)combined);
            } else {
                result = super.transform(opJoin, left, right);
            }
        } else {
            result = velLeft != null ? OpExtend.extend((Op)OpJoin.create((Op)ol.getSubOp(), (Op)right), (VarExprList)velLeft) : (velRight != null ? OpExtend.extend((Op)OpJoin.create((Op)left, (Op)or.getSubOp()), (VarExprList)velRight) : super.transform(opJoin, left, right));
        }
        return result;
    }

    public static void main(String[] args) {
        String str = "SELECT * WHERE\n  { SELECT DISTINCT  ?__g__ ?__s__ ?__p__ ?__o__\n    WHERE\n      { { SELECT  ?jc0 ?v4\n          WHERE\n            { SERVICE <https://w3id.org/aksw/sparqlx#rml.source>\n                { <https://w3id.org/aksw/sparqlx#rml.source>\n                            a                     <http://semweb.mmlab.be/ns/rml#LogicalSource> ;\n                            <http://semweb.mmlab.be/ns/rml#referenceFormulation>  <http://semweb.mmlab.be/ns/ql#CSV> ;\n                            <http://semweb.mmlab.be/ns/rml#source>  \"ROUTES.csv\" ;\n                            <https://w3id.org/function/ontology#returns>  ?s0\n                }\n              BIND(<http://jsa.aksw.org/fn/json/path>(?s0, \"$['agency_id']\") AS ?jc0)\n              FILTER bound(?jc0)\n              BIND(IRI(concat(\"http://transport.linkeddata.es/madrid/metro/routes/\", encode_for_uri(str(<http://jsa.aksw.org/fn/json/path>(?s0, \"$['route_id']\"))))) AS ?v4)\n            }\n          LIMIT   9223372036854775807\n        }\n        { SELECT  ?jc0 ?s1_v4\n          WHERE\n            { SERVICE <https://w3id.org/aksw/sparqlx#rml.source>\n                { <https://w3id.org/aksw/sparqlx#rml.source>\n                            a                     <http://semweb.mmlab.be/ns/rml#LogicalSource> ;\n                            <http://semweb.mmlab.be/ns/rml#referenceFormulation>  <http://semweb.mmlab.be/ns/ql#CSV> ;\n                            <http://semweb.mmlab.be/ns/rml#source>  \"AGENCY.csv\" ;\n                            <https://w3id.org/function/ontology#returns>  ?s1\n                }\n              BIND(<http://jsa.aksw.org/fn/json/path>(?s1, \"$['agency_id']\") AS ?jc0)\n              FILTER bound(?jc0)\n              BIND(IRI(concat(\"http://transport.linkeddata.es/madrid/agency/\", encode_for_uri(str(<http://jsa.aksw.org/fn/json/path>(?s1, \"$['agency_id']\"))))) AS ?s1_v4)\n            }\n          LIMIT   9223372036854775807\n        }\n        LATERAL {\n          { BIND(<urn:x-arq:DefaultGraphNode> AS ?__g__)\n            BIND(?v4 AS ?__s__)\n            BIND(<http://vocab.gtfs.org/terms#agency> AS ?__p__)\n            BIND(?s1_v4 AS ?__o__)\n          } UNION \n          { BIND(<urn:x-arq:DefaultGraphNode> AS ?__g__)\n            BIND(?v1_v4 AS ?__s__)\n            BIND(<http://vocab.gtfs.org/terms#agency> AS ?__p__)\n            BIND(?v4 AS ?__o__)\n          }\n      } } \n  }\n";
        Query query = QueryFactory.create((String)str);
        System.out.println(query);
        Op op = Algebra.compile((Query)query);
        op = Transformer.transform((Transform)new TransformPullExtend(), (Op)op);
        Query newQuery = OpAsQuery.asQuery((Op)op);
        System.out.println(newQuery);
    }
}

