/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.HashSet;
import java.util.Set;
import org.aksw.commons.util.obj.ObjectUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.core.VarExprList;

public class TransformOptimizeSubQueries
extends TransformCopy {
    public Op transform(OpProject op, Op subOp) {
        Op result = null;
        Set subOpVars = OpVars.visibleVars((Op)subOp);
        HashSet thisVars = new HashSet(op.getVars());
        boolean isNeedless = thisVars.equals(subOpVars);
        if (isNeedless) {
            result = subOp;
        } else {
            OpSlice slice = (OpSlice)ObjectUtils.castAsOrNull(OpSlice.class, (Object)subOp);
            if (slice != null) {
                result = new OpSlice((Op)new OpProject(slice.getSubOp(), op.getVars()), slice.getStart(), slice.getLength());
            }
        }
        if (result == null) {
            result = super.transform(op, subOp);
        }
        return result;
    }

    public Op transform(OpExtend op, Op subOp) {
        Op result = null;
        OpSlice slice = (OpSlice)ObjectUtils.castAsOrNull(OpSlice.class, (Object)subOp);
        if (slice != null) {
            result = new OpSlice((Op)OpExtend.create((Op)slice.getSubOp(), (VarExprList)new VarExprList(op.getVarExprList())), slice.getStart(), slice.getLength());
        }
        if (result == null) {
            result = super.transform(op, subOp);
        }
        return result;
    }
}

