/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.expr.transform;

import java.util.Objects;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.E_URI;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprTransformConstantFoldWithIris
extends ExprTransformConstantFold {
    private static final Logger logger = LoggerFactory.getLogger(ExprTransformConstantFoldWithIris.class);
    private FunctionEnv functionEnv;
    private String functionEnvBaseUri = null;

    public ExprTransformConstantFoldWithIris() {
        this((FunctionEnv)ExecutionContext.create((Context)ARQ.getContext().copy()));
    }

    public ExprTransformConstantFoldWithIris(FunctionEnv functionEnv) {
        this.functionEnv = Objects.requireNonNull(functionEnv);
        this.functionEnvBaseUri = ExprTransformConstantFoldWithIris.extractBaseUri(functionEnv.getContext());
    }

    public FunctionEnv getFunctionEnv() {
        return this.functionEnv;
    }

    public String getFunctionEnvBaseUri() {
        return this.functionEnvBaseUri;
    }

    private static String extractBaseUri(Context context) {
        Query query = null;
        if (context != null) {
            try {
                query = (Query)context.get(ARQConstants.sysCurrentQuery);
            }
            catch (Exception e) {
                logger.warn("Unexpected error", (Throwable)e);
            }
        }
        String result = query == null ? null : query.getBaseURI();
        return result;
    }

    public Expr transform(ExprFunction1 func, Expr expr1) {
        Expr r = null;
        if (expr1.isConstant()) {
            NodeValue nv = expr1.getConstant();
            try {
                E_URI e_uri;
                if (func instanceof E_IRI) {
                    E_IRI e_iri = (E_IRI)func;
                    if (this.isEligibleForEval(e_iri.getParserBase())) {
                        r = e_iri.eval(nv, this.getFunctionEnv());
                    }
                } else if (func instanceof E_URI && this.isEligibleForEval((e_uri = (E_URI)func).getParserBase())) {
                    r = e_uri.eval(nv, this.getFunctionEnv());
                }
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }
        if (r == null) {
            r = super.transform(func, expr1);
        }
        return r;
    }

    protected boolean isEligibleForEval(String base) {
        boolean result = this.functionEnvBaseUri != null || base != null;
        return result;
    }
}

