/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.MultimapUtils;
import org.aksw.jena_sparql_api.algebra.analysis.VarUsage2;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVars;

public class VarUsageAnalyzer2Visitor
extends OpVisitorBase {
    protected Map<Op, VarUsage2> opToVarUsage = new IdentityHashMap<Op, VarUsage2>();

    public Map<Op, VarUsage2> getResult() {
        return this.opToVarUsage;
    }

    public void processExprs(Op op, ExprList exprs) {
        if (exprs != null) {
            Set vars = ExprVars.getVarsMentioned((ExprList)exprs);
            this.markEssential(op, vars);
        }
    }

    public void processExpr(Op op, Expr expr) {
        if (expr != null) {
            Set vars = ExprVars.getVarsMentioned((Expr)expr);
            this.markEssential(op, vars);
        }
    }

    public void processJoin(Op op, Collection<Op> subOps) {
        for (Op subOp : subOps) {
            subOp.visit((OpVisitor)this);
        }
        VarUsage2 varUsage = this.allocate(op);
        LinkedHashSet<Var> joinVars = null;
        Sets.SetView visibleVars = new LinkedHashSet();
        for (Op subOp : subOps) {
            VarUsage2 subVarUsage = this.opToVarUsage.get(subOp);
            if (subVarUsage == null) {
                throw new NullPointerException();
            }
            Set<Var> argVars = subVarUsage.getVisibleVars();
            visibleVars.addAll(argVars);
            joinVars = joinVars == null ? visibleVars : Sets.intersection(joinVars, visibleVars);
        }
        joinVars = new LinkedHashSet<Var>(joinVars);
        varUsage.setVisibleVars((Set<Var>)visibleVars);
        this.markEssential(op, joinVars);
    }

    public void pushDownDistinct(Op op) {
        VarUsage2 varUsage = this.opToVarUsage.get(op);
        varUsage.setDistinct(true);
        for (Op subOp : OpUtils.getSubOps(op)) {
            if (subOp instanceof OpGroup) continue;
            this.pushDownDistinct(subOp);
        }
    }

    public void processDistinct(Op op, Op subOp) {
        subOp.visit((OpVisitor)this);
        VarUsage2 varUsage = this.allocate(op);
        this.reuseVisibleVars(varUsage, subOp);
        this.pushDownDistinct(op);
    }

    public void visit(OpJoin op) {
        List<Op> subOps = Arrays.asList(op.getLeft(), op.getRight());
        this.processJoin((Op)op, subOps);
    }

    public void visit(OpLeftJoin op) {
        this.processJoin((Op)op, Arrays.asList(op.getLeft(), op.getRight()));
        this.processExprs((Op)op, op.getExprs());
    }

    public void visit(OpSequence op) {
        this.processJoin((Op)op, op.getElements());
    }

    public void processUnion(Op op, List<Op> subOps) {
        ArrayList<VarUsage2> subVarUsages = new ArrayList<VarUsage2>(subOps.size());
        for (Op subOp : subOps) {
            subOp.visit((OpVisitor)this);
            VarUsage2 varUsage = this.opToVarUsage.get(subOp);
            subVarUsages.add(varUsage);
        }
        VarUsage2 varUsage = this.allocate(op);
        LinkedHashSet<Var> visibleVars = new LinkedHashSet<Var>();
        for (VarUsage2 subVarUsage : subVarUsages) {
            visibleVars.addAll(subVarUsage.getVisibleVars());
        }
        varUsage.setVisibleVars(visibleVars);
    }

    public void visit(OpDisjunction op) {
        List<Op> subOps = OpUtils.getSubOps((Op)op);
        this.processUnion((Op)op, subOps);
    }

    public void visit(OpUnion op) {
        List<Op> subOps = Arrays.asList(op.getLeft(), op.getRight());
        this.processUnion((Op)op, subOps);
    }

    public void visit(OpGroup op) {
        throw new UnsupportedOperationException();
    }

    public void visit(OpExtend op) {
        this.processExtend((Op)op, op.getSubOp(), op.getVarExprList());
    }

    public void visit(OpExt opExt) {
        Op effectiveOp = opExt.effectiveOp();
        if (effectiveOp == null) {
            throw new IllegalArgumentException("Default handing of OpExt requires an effectiveOp");
        }
        effectiveOp.visit((OpVisitor)this);
        VarUsage2 varUsage = this.opToVarUsage.get(effectiveOp);
        this.opToVarUsage.put((Op)opExt, varUsage);
    }

    public void visit(OpAssign op) {
        this.processExtend((Op)op, op.getSubOp(), op.getVarExprList());
    }

    public void visit(OpOrder op) {
        op.getSubOp().visit((OpVisitor)this);
        for (SortCondition sc : op.getConditions()) {
            this.processExpr((Op)op, sc.getExpression());
        }
    }

    public void processExtend(Op op, Op subOp, VarExprList vel) {
        subOp.visit((OpVisitor)this);
        VarUsage2 varUsage = this.opToVarUsage.put(op, new VarUsage2());
        VarUsage2 subVarUsage = this.opToVarUsage.get(subOp);
        HashMultimap varDeps = HashMultimap.create();
        HashMultimap updates = HashMultimap.create();
        for (Map.Entry e : vel.getExprs().entrySet()) {
            Var v = (Var)e.getKey();
            Expr ex = (Expr)e.getValue();
            Set vars = ex == null ? Collections.singleton(v) : ExprVars.getVarsMentioned((Expr)ex);
            for (Var w : vars) {
                Collection deps = varDeps.get((Object)w);
                updates.putAll((Object)v, (Iterable)deps);
            }
        }
        updates.asMap().forEach((arg_0, arg_1) -> VarUsageAnalyzer2Visitor.lambda$processExtend$0((Multimap)varDeps, arg_0, arg_1));
    }

    public void reuseVisibleVars(VarUsage2 target, Op subOp) {
        VarUsage2 subVarUsage = this.opToVarUsage.get(subOp);
        Set<Var> vars = subVarUsage.getVisibleVars();
        target.setVisibleVars(vars);
    }

    public void visit(OpFilter op) {
        op.getSubOp().visit((OpVisitor)this);
        VarUsage2 varUsage = new VarUsage2();
        this.opToVarUsage.put((Op)op, varUsage);
        this.reuseVisibleVars(varUsage, op.getSubOp());
        this.processExprs((Op)op, op.getExprs());
    }

    public void visit(OpDistinct op) {
        this.processDistinct((Op)op, op.getSubOp());
    }

    public void visit(OpReduced op) {
        this.processDistinct((Op)op, op.getSubOp());
    }

    public void markEssential(Op op, Set<Var> vars) {
        VarUsageAnalyzer2Visitor.markEssential(this.opToVarUsage, op, vars);
    }

    public static void markEssential(Map<Op, VarUsage2> opToVarUsage, Op op, Set<Var> vars) {
        VarUsage2 varUsage = opToVarUsage.get(op);
        Multimap<Var, Var> varDeps = varUsage.getVarDeps();
        Set nextVars = varDeps == null ? vars : MultimapUtils.getAll(varDeps, vars);
        varUsage.getEssentialVars().addAll(vars);
        for (Op subOp : OpUtils.getSubOps(op)) {
            VarUsageAnalyzer2Visitor.markEssential(opToVarUsage, subOp, nextVars);
        }
    }

    public VarUsage2 allocate(Op op) {
        VarUsage2 result = new VarUsage2();
        this.opToVarUsage.put(op, result);
        return result;
    }

    public void visit(OpProject op) {
        op.getSubOp().visit((OpVisitor)this);
        VarUsage2 varUsage = this.allocate((Op)op);
        Sets.SetView outVars = new LinkedHashSet(op.getVars());
        Set<Var> inVars = this.opToVarUsage.get(op.getSubOp()).getVisibleVars();
        outVars = Sets.intersection(outVars, inVars);
        varUsage.setVisibleVars((Set<Var>)outVars);
    }

    public void visit(OpQuadPattern op) {
        VarUsage2 varUsage = this.allocate((Op)op);
        Set suppliedVars = OpVars.visibleVars((Op)op);
        varUsage.setVisibleVars(suppliedVars);
    }

    public static Map<Op, VarUsage2> analyze(Op op) {
        VarUsageAnalyzer2Visitor varUsageAnalyzer = new VarUsageAnalyzer2Visitor();
        Map<Op, VarUsage2> result = VarUsageAnalyzer2Visitor.analyze(op, varUsageAnalyzer);
        return result;
    }

    public static Map<Op, VarUsage2> analyze(Op op, VarUsageAnalyzer2Visitor varUsageAnalyzer) {
        op.visit((OpVisitor)varUsageAnalyzer);
        Map<Op, VarUsage2> result = varUsageAnalyzer.getResult();
        VarUsage2 varUsage = result.get(op);
        Set<Var> visibleVars = varUsage.getVisibleVars();
        VarUsageAnalyzer2Visitor.markEssential(result, op, visibleVars);
        return result;
    }

    private static /* synthetic */ void lambda$processExtend$0(Multimap varDeps, Var k, Collection w) {
        varDeps.replaceValues((Object)k, (Iterable)w);
    }
}

