/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.analysis;

import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.sparql.core.Var;

public class VarUsage {
    protected Set<Var> referencedVars;
    protected Set<Var> nonUnique;
    protected Multimap<Var, Var> varDeps;
    protected Set<Set<Var>> uniqueSets;

    public VarUsage(Set<Var> referencedVars, Set<Var> nonUnique, Multimap<Var, Var> varDeps, Set<Set<Var>> uniqueSets) {
        this.referencedVars = referencedVars;
        this.nonUnique = nonUnique;
        this.varDeps = varDeps;
        this.uniqueSets = uniqueSets;
    }

    public Set<Var> getReferencedVars() {
        return this.referencedVars;
    }

    public Set<Var> getNonUnique() {
        return this.nonUnique;
    }

    public Multimap<Var, Var> getVarDeps() {
        return this.varDeps;
    }

    public Set<Set<Var>> getUniqueSets() {
        return this.uniqueSets;
    }

    public String toString() {
        return "VarUsage[ proj:" + String.valueOf(this.varDeps.keySet()) + ", refs: " + String.valueOf(this.referencedVars) + ", deps: " + String.valueOf(this.varDeps) + ", non-uniq: " + String.valueOf(this.nonUnique) + ", uniq sets: " + String.valueOf(this.uniqueSets) + "]";
    }

    public static Set<Var> getMandatoryVars(VarUsage varUsage) {
        HashSet<Var> result = new HashSet<Var>();
        result.addAll(varUsage.referencedVars);
        result.addAll(varUsage.varDeps.values());
        return result;
    }
}

