/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.apache.jena.sparql.expr.E_Add;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprTransformCopy;

public class ExprTransformVariableOrder
extends ExprTransformCopy {
    protected Predicate<Expr> isCommutative;
    public static final Set<Class<?>> symmetricExprClasses = new HashSet<Class>(Arrays.asList(E_Equals.class, E_Add.class, E_Multiply.class));

    public ExprTransformVariableOrder() {
        this(ExprTransformVariableOrder::isCommutative);
    }

    public ExprTransformVariableOrder(Predicate<Expr> isCommutative) {
        this.isCommutative = isCommutative;
    }

    public Expr transform(ExprFunction2 func, Expr a, Expr b) {
        List<Expr> args = Arrays.asList(a, b);
        if (this.isCommutative.test((Expr)func)) {
            Collections.sort(args, ExprUtils::compare);
        }
        return super.transform(func, args.get(0), args.get(1));
    }

    public static boolean isCommutative(Expr e) {
        boolean result = symmetricExprClasses.contains(e.getClass());
        return result;
    }
}

