/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.aksw.commons.util.obj.ObjectUtils;
import org.aksw.jena_sparql_api.algebra.transform.TransformJoinToSequence;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;

public class OpServiceUtils {
    public static Multimap<String, Op> extractServiceArgs(OpService rootOp) {
        OpSequence seq = OpSequence.create();
        TransformJoinToSequence.addRecursive(seq, rootOp.getSubOp());
        ArrayListMultimap result = ArrayListMultimap.create();
        for (Op op : seq.getElements()) {
            OpService sop = (OpService)ObjectUtils.castAsOrNull(OpService.class, (Object)op);
            if (sop == null) continue;
            String iri = NodeUtils.getIriOrNull((Node)sop.getService());
            if (iri != null) {
                result.put((Object)iri, (Object)sop.getSubOp());
                continue;
            }
            throw new IllegalArgumentException(String.valueOf(rootOp) + " service member without IRI not allowed");
        }
        return result;
    }

    public static String getIriOrNull(OpService opService) {
        return opService == null ? null : NodeUtils.getIriOrNull((Node)opService.getService());
    }
}

