/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.jena_sparql_api.algebra.transform.TransformPullFiltersIfCanMergeBGPs;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.expr.ExprList;

public class TransformPullFilters
extends TransformCopy {
    public static Op transform(Op op) {
        TransformPullFilters transform = new TransformPullFilters();
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public boolean condition(Op op) {
        return true;
    }

    public static void todoMoveToUnitTest(String[] args) {
        String input = "SELECT * {\n    {\n       ?s ?p ?o\n       FILTER(?s = 'a' || ?o = 'b')\n       FILTER(?p = 'x')\n    }  UNION\n    {\n       ?s ?p ?o\n       FILTER(?s = 'a' || ?o = 'b')\n       FILTER(?p = 'y')\n    }\n}";
        Op expected = Algebra.compile((Query)QueryFactory.create((String)"SELECT  *\nWHERE\n  {   { ?s  ?p  ?o\n        FILTER ( ?p = \"x\" )\n      }\n    UNION\n      { ?s  ?p  ?o\n        FILTER ( ?p = \"y\" )\n      }\n    FILTER ( ( ?s = \"a\" ) || ( ?o = \"b\" ) )\n  }"));
        Op a = Algebra.compile((Query)QueryFactory.create((String)input));
        Op actual = TransformPullFilters.transform(a);
        Query bq = OpAsQuery.asQuery((Op)actual);
        System.out.println(bq);
        System.out.println(Objects.equals(expected, actual));
    }

    public static Op xtransformUnion(Collection<? extends Op> subOps, Function<? super List<Op>, ? extends Op> unionCtor, Predicate<? super Op> applyCondition) {
        ArrayList<Op> newSubOps = new ArrayList<Op>();
        ArrayList els = new ArrayList(subOps.size());
        for (Op op : subOps) {
            if (op instanceof OpFilter && applyCondition.test((Op)op)) {
                OpFilter tidied = OpFilter.tidy((OpFilter)((OpFilter)op));
                boolean containsSpecialVar = TransformPullFiltersIfCanMergeBGPs.containsSpecialVar(tidied.getExprs().getVarsMentioned());
                if (containsSpecialVar) {
                    newSubOps = null;
                    continue;
                }
                els.add(new LinkedHashSet(tidied.getExprs().getList()));
                continue;
            }
            newSubOps = null;
        }
        Op result = null;
        if (newSubOps != null) {
            int i;
            LinkedHashSet linkedHashSet = els.isEmpty() ? Collections.emptySet() : new LinkedHashSet((Collection)els.get(0));
            for (i = 1; i < els.size(); ++i) {
                Set e = (Set)els.get(i);
                linkedHashSet.retainAll(e);
            }
            if (!linkedHashSet.isEmpty()) {
                i = 0;
                for (Op op : subOps) {
                    Set e = (Set)els.get(i++);
                    Sets.SetView remain = Sets.difference((Set)e, linkedHashSet);
                    Op newSubOp = ((OpFilter)op).getSubOp();
                    if (!remain.isEmpty()) {
                        ExprList tmp = new ExprList(new ArrayList(remain));
                        newSubOp = OpFilter.filterBy((ExprList)tmp, (Op)newSubOp);
                    }
                    newSubOps.add(newSubOp);
                }
                result = OpFilter.filterBy((ExprList)new ExprList(new ArrayList(linkedHashSet)), (Op)unionCtor.apply(newSubOps));
            }
        }
        if (result == null) {
            result = unionCtor.apply(new ArrayList<Op>(subOps));
        }
        return result;
    }

    public Op transform(OpJoin opJoin, Op left, Op right) {
        Op tmp = TransformPullFiltersIfCanMergeBGPs.xtransform(Arrays.asList(left, right), subOps -> OpJoin.create((Op)((Op)subOps.get(0)), (Op)((Op)subOps.get(1))), this::condition);
        Op result = tmp == null ? super.transform(opJoin, left, right) : tmp;
        return result;
    }

    public Op transform(OpUnion opUnion, Op left, Op right) {
        Op tmp = TransformPullFilters.xtransformUnion(Arrays.asList(left, right), subOps -> OpUnion.create((Op)((Op)subOps.get(0)), (Op)((Op)subOps.get(1))), this::condition);
        Op result = tmp == null ? super.transform(opUnion, left, right) : tmp;
        return result;
    }
}

