/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.expr.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransformCopy;

public class ExprTransformFlattenFunction
extends ExprTransformCopy {
    protected Predicate<? super Expr> isFlattenableFunction;

    public ExprTransformFlattenFunction(Predicate<? super Expr> isFlattenableFunction) {
        this.isFlattenableFunction = isFlattenableFunction;
    }

    public Expr transform(ExprFunctionN func, ExprList args) {
        Expr result = this.isFlattenableFunction.test((Expr)func) ? func.copy(new ExprList(ExprTransformFlattenFunction.flatten(func.getArgs(), this.isFlattenableFunction))) : super.transform(func, args);
        return result;
    }

    public static List<Expr> flatten(List<Expr> args, Predicate<? super Expr> isFlattenableFunction) {
        ArrayList<Expr> tmpArgs = new ArrayList<Expr>();
        boolean change = false;
        for (Expr arg : args) {
            if (arg.isFunction()) {
                ExprFunction fn = arg.getFunction();
                if (isFlattenableFunction.test((Expr)fn)) {
                    change = true;
                    tmpArgs.addAll(fn.getArgs());
                    continue;
                }
                tmpArgs.add(arg);
                continue;
            }
            tmpArgs.add(arg);
        }
        ArrayList<Expr> result = change ? tmpArgs : args;
        return result;
    }
}

