/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.expr.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.NodeValue;

public class ExprTransformConcatMergeConstants
extends ExprTransformCopy {
    protected Predicate<? super Expr> isConcatFunction;

    public ExprTransformConcatMergeConstants(Predicate<? super Expr> isConcatFunction) {
        this.isConcatFunction = isConcatFunction;
    }

    public Expr transform(ExprFunctionN func, ExprList args) {
        Expr result = this.isConcatFunction.test((Expr)func) ? func.copy(new ExprList(ExprTransformConcatMergeConstants.mergeConsecutiveConstants(args.getList()))) : super.transform(func, args);
        return result;
    }

    public static List<Expr> mergeConsecutiveConstants(Iterable<Expr> exprs) {
        String prev = null;
        ArrayList<Expr> newExprs = new ArrayList<Expr>();
        for (Expr expr : exprs) {
            if (expr.isConstant()) {
                prev = (String)(prev == null ? "" : prev) + expr.getConstant().asString();
                continue;
            }
            if (prev != null) {
                newExprs.add((Expr)NodeValue.makeString(prev));
                prev = null;
            }
            newExprs.add(expr);
        }
        if (prev != null) {
            newExprs.add((Expr)NodeValue.makeString(prev));
        }
        return newExprs;
    }
}

