/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.algebra.transform2;

import java.util.Objects;
import org.aksw.jenax.sparql.algebra.transform2.ApplyEvaluationVisitor;
import org.aksw.jenax.sparql.algebra.transform2.Evaluation;
import org.aksw.jenax.sparql.algebra.transform2.EvaluationBase;
import org.aksw.jenax.sparql.algebra.transform2.EvaluationWrapper;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.walker.Walker;
import org.apache.jena.sparql.expr.ExprVisitor;

public class Evaluator {
    private static Evaluator singleton = new Evaluator();

    public static Evaluator get() {
        return singleton;
    }

    public static void set(Evaluator value) {
        singleton = value;
    }

    public static <T> T evaluate(Evaluation<T> evaluation, Op op) {
        return Evaluator.evaluate(evaluation, op, null, null);
    }

    public static <T> T evaluate(Evaluation<T> evaluation, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Evaluator.get().evaluate$(evaluation, op, beforeVisitor, afterVisitor);
    }

    public <T> T evaluate$(Evaluation<T> transform, Op op) {
        return this.evaluate$(transform, op, null, null);
    }

    public <T> T evaluate$(Evaluation<T> v, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        ApplyEvaluationVisitor<T> evaluationVisitor = this.createEvaluator(v);
        return this.evaluate(op, evaluationVisitor, beforeVisitor, afterVisitor);
    }

    public static <T> T evaluateSkipService(Evaluation<T> evaluation, Op op) {
        return Evaluator.evaluateSkipService(evaluation, op, null, null);
    }

    public static <T> T evaluateSkipService(Evaluation<T> evaluation, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (evaluation == null) {
            evaluation = new EvaluationBase();
        }
        ApplyEvaluationVisitor aev = new ApplyEvaluationVisitor<T>((Evaluation)evaluation){

            @Override
            public void visit(OpService op) {
                Object value = this.evaluator.eval(op, null);
                this.push(this.opStack, value);
            }
        };
        Walker.walkSkipService((Op)op, (OpVisitor)aev, (ExprVisitor)aev, (OpVisitor)beforeVisitor, (OpVisitor)afterVisitor);
        Object result = aev.opResult();
        return result;
    }

    public <T> ApplyEvaluationVisitor<T> createEvaluator(Evaluation<T> evaluation) {
        Objects.requireNonNull(evaluation);
        return new ApplyEvaluationVisitor<T>(evaluation);
    }

    public <T> T evaluate(Op op, ApplyEvaluationVisitor<T> v, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        Walker.walk((Op)op, v, v, (OpVisitor)beforeVisitor, (OpVisitor)afterVisitor);
        T result = v.opResult();
        return result;
    }

    static class EvaluationSkipService<T>
    extends EvaluationWrapper<T> {
        public EvaluationSkipService(Evaluation<T> evaluator) {
            super(evaluator);
        }

        @Override
        public T eval(OpService opService, T arg) {
            return null;
        }
    }
}

