/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.algebra.transform2;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.aksw.jenax.sparql.algebra.transform2.Evaluation;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.OpAntiJoin;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSemiJoin;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnfold;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.walker.ApplyTransformVisitor;
import org.apache.jena.sparql.algebra.walker.Walker;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformBase;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;

public class ApplyEvaluationVisitor<T>
implements OpVisitor,
ExprVisitor {
    protected final Evaluation<T> evaluator;
    protected final Deque<T> opStack = new ArrayDeque<T>();
    protected final Deque<Expr> exprStack = new ArrayDeque<Expr>();
    protected final ExprTransform exprTransform = new ExprTransformBase();

    public ApplyEvaluationVisitor(Evaluation<T> evaluator) {
        this.evaluator = evaluator;
    }

    public final T opResult() {
        return this.pop(this.opStack);
    }

    protected void push(Deque<T> stack, T value) {
        if (value == null) {
            Log.warn(ApplyEvaluationVisitor.class, (String)("Pushing null onto the " + this.stackLabel(stack) + " stack"));
        }
        stack.push(value);
    }

    private <X> X pop(Deque<X> stack) {
        try {
            X v = stack.pop();
            if (v == null) {
                Log.warn(ApplyEvaluationVisitor.class, (String)("Pop null from the " + this.stackLabel(stack) + " stack"));
            }
            return v;
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException(ex);
        }
    }

    public T pop(Deque<T> stack, Op op) {
        T result = op != null ? (T)this.pop(stack) : null;
        return result;
    }

    public List<T> pop(Deque<T> stack, List<Op> ops) {
        int n = ops.size();
        List<Object> result = Arrays.asList(new Object[n]);
        ListIterator<Op> it = ops.listIterator(n);
        int i = n;
        while (it.hasPrevious()) {
            Op op = it.previous();
            T value = this.pop(stack, op);
            result.set(--i, value);
        }
        return result;
    }

    private String stackLabel(Deque<?> stack) {
        return stack == this.opStack ? "Op" : (stack == this.exprStack ? "Expr" : "<other>");
    }

    public void visit(OpBGP op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpQuadPattern op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpQuadBlock op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpTriple op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpQuad op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpPath op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpTable op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpNull op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpProcedure op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpPropFunc op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpGraph op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpDatasetNames op) {
        T value = this.evaluator.eval(op);
        this.push(this.opStack, value);
    }

    public void visit(OpLabel op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpJoin op) {
        T right = this.pop(this.opStack, op.getRight());
        T left = this.pop(this.opStack, op.getLeft());
        T value = this.evaluator.eval(op, left, right);
        this.push(this.opStack, value);
    }

    public void visit(OpUnion op) {
        T right = this.pop(this.opStack, op.getRight());
        T left = this.pop(this.opStack, op.getLeft());
        T value = this.evaluator.eval(op, left, right);
        this.push(this.opStack, value);
    }

    public void visit(OpSemiJoin op) {
        T right = this.pop(this.opStack, op.getRight());
        T left = this.pop(this.opStack, op.getLeft());
        T value = this.evaluator.eval(op, left, right);
        this.push(this.opStack, value);
    }

    public void visit(OpAntiJoin op) {
        T right = this.pop(this.opStack, op.getRight());
        T left = this.pop(this.opStack, op.getLeft());
        T value = this.evaluator.eval(op, left, right);
        this.push(this.opStack, value);
    }

    public void visit(OpMinus op) {
        T right = this.pop(this.opStack, op.getRight());
        T left = this.pop(this.opStack, op.getLeft());
        T value = this.evaluator.eval(op, left, right);
        this.push(this.opStack, value);
    }

    public void visit(OpLateral op) {
        T right = this.pop(this.opStack, op.getRight());
        T left = this.pop(this.opStack, op.getLeft());
        T value = this.evaluator.eval(op, left, right);
        this.push(this.opStack, value);
    }

    public void visit(OpConditional op) {
        T right = this.pop(this.opStack, op.getRight());
        T left = this.pop(this.opStack, op.getLeft());
        T value = this.evaluator.eval(op, left, right);
        this.push(this.opStack, value);
    }

    public void visit(OpSequence op) {
        List<T> values = this.pop(this.opStack, op.getElements());
        T value = this.evaluator.eval(op, values);
        this.push(this.opStack, value);
    }

    public void visit(OpDisjunction op) {
        List<T> values = this.pop(this.opStack, op.getElements());
        T value = this.evaluator.eval(op, values);
        this.push(this.opStack, value);
    }

    public void visit(OpList op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpProject op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpReduced op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpDistinct op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpSlice op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpTopN op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpFilter op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpService op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpAssign op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpExtend op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpLeftJoin op) {
        T right = this.pop(this.opStack, op.getRight());
        T left = this.pop(this.opStack, op.getLeft());
        T value = this.evaluator.eval(op, left, right);
        this.push(this.opStack, value);
    }

    public void visit(OpOrder op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpGroup op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    public void visit(OpUnfold op) {
        T sub = this.pop(this.opStack, op.getSubOp());
        T value = this.evaluator.eval(op, sub);
        this.push(this.opStack, value);
    }

    final Expr exprResult() {
        return this.popExpr(this.exprStack);
    }

    private <X> void pushExpr(Deque<X> stack, X value) {
        if (value == null) {
            Log.warn(ApplyTransformVisitor.class, (String)("Pushing null onto the " + this.stackLabel(stack) + " stack"));
        }
        stack.push(value);
    }

    private <T> T popExpr(Deque<T> stack) {
        try {
            T v = stack.pop();
            if (v == null) {
                Log.warn(ApplyTransformVisitor.class, (String)("Pop null from the " + this.stackLabel(stack) + " stack"));
            }
            return v;
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException();
        }
    }

    private VarExprList collect(VarExprList varExprList) {
        if (varExprList == null) {
            return varExprList;
        }
        List vars = varExprList.getVars();
        VarExprList varExpr2 = new VarExprList();
        List<Expr> x = this.collect(vars.size());
        boolean changed = false;
        for (int i = 0; i < vars.size(); ++i) {
            Var v = (Var)vars.get(i);
            Expr e2 = x.get(i);
            Expr e = varExpr2.getExpr(v);
            if (e != e2) {
                changed = true;
            }
            if (e2 == null) {
                varExpr2.add(v);
                continue;
            }
            varExpr2.add(v, e2);
        }
        return changed ? varExpr2 : varExprList;
    }

    private ExprList collect(ExprList exprList) {
        if (exprList == null) {
            return null;
        }
        List<Expr> x = this.collect(exprList.size());
        boolean changed = false;
        for (int i = 0; i < x.size(); ++i) {
            if (x.get(i) == exprList.get(i)) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return exprList;
        }
        return new ExprList(x);
    }

    private ExprList collect(List<Expr> exprList) {
        if (exprList == null) {
            return null;
        }
        return new ExprList(this.collect(exprList.size()));
    }

    private List<Expr> collect(int N) {
        ArrayList<Expr> x = new ArrayList<Expr>(N);
        for (int i = N - 1; i >= 0; --i) {
            Expr e2 = this.popExpr(this.exprStack);
            if (e2 == Expr.NONE) {
                e2 = null;
            }
            x.add(0, e2);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expr transform(Expr expr) {
        int x1 = this.opStack.size();
        int x2 = this.exprStack.size();
        try {
            Object beforeVisitor = null;
            Object afterVisitor = null;
            Expr result = Walker.transform((Expr)expr, (ExprTransform)new ExprTransformBase());
            Expr expr2 = expr;
            return expr2;
        }
        finally {
            int y1 = this.opStack.size();
            int y2 = this.exprStack.size();
            if (x1 != y1) {
                Log.error(ApplyTransformVisitor.class, (String)"Misaligned opStack");
            }
            if (x2 != y2) {
                Log.error(ApplyTransformVisitor.class, (String)"Misaligned exprStack");
            }
        }
    }

    protected ExprList transform(ExprList exprList) {
        ExprList exprList2 = new ExprList();
        exprList.forEach(e -> exprList2.add(this.transform((Expr)e)));
        return exprList2;
    }

    protected List<SortCondition> transform(List<SortCondition> conditions) {
        ArrayList<SortCondition> conditions2 = new ArrayList<SortCondition>();
        boolean changed = false;
        for (SortCondition sc : conditions) {
            Expr e = sc.getExpression();
            Expr e2 = this.transform(e);
            conditions2.add(new SortCondition(e2, sc.getDirection()));
            if (e == e2) continue;
            changed = true;
        }
        if (changed) {
            return conditions2;
        }
        return conditions;
    }

    public void visit(ExprFunction0 func) {
        Expr e = func.apply(this.exprTransform);
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprFunction1 func) {
        Expr e1 = this.pop(this.exprStack);
        Expr e = func.apply(this.exprTransform, e1);
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprFunction2 func) {
        Expr e2 = this.pop(this.exprStack);
        Expr e1 = this.pop(this.exprStack);
        Expr e = func.apply(this.exprTransform, e1, e2);
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprFunction3 func) {
        Expr e3 = this.pop(this.exprStack);
        Expr e2 = this.pop(this.exprStack);
        Expr e1 = this.pop(this.exprStack);
        Expr e = func.apply(this.exprTransform, e1, e2, e3);
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprFunctionN func) {
        ExprList x = this.collect(func.getArgs());
        Expr e = func.apply(this.exprTransform, x);
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprFunctionOp funcOp) {
        ExprList x = null;
        if (funcOp.getArgs() != null) {
            x = this.collect(funcOp.getArgs());
        }
        T value = this.pop(this.opStack);
        Expr e = funcOp.apply(this.exprTransform, x, funcOp.getGraphPattern());
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprTripleTerm tripleTerm) {
        ExprTripleTerm e = tripleTerm;
        this.pushExpr(this.exprStack, e);
    }

    public void visit(NodeValue nv) {
        Expr e = nv.apply(this.exprTransform);
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprVar var) {
        Expr e = var.apply(this.exprTransform);
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprAggregator eAgg) {
        Expr e = eAgg.apply(this.exprTransform);
        this.pushExpr(this.exprStack, e);
    }

    public void visit(ExprNone e) {
        this.pushExpr(this.exprStack, e);
    }
}

