/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.algebra.eval;

import java.util.Stack;
import org.aksw.jenax.sparql.algebra.eval.Evaluator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.OpAntiJoin;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSemiJoin;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnfold;
import org.apache.jena.sparql.algebra.op.OpUnion;

public class EvaluationDispatch<T>
implements OpVisitor {
    protected Stack<T> stack = new Stack();
    protected Evaluator<T> evaluator;

    public EvaluationDispatch(Evaluator<T> evaluator) {
        this.evaluator = evaluator;
    }

    public T eval(Op op, T input) {
        this.push(input);
        int x = this.stack.size();
        op.visit((OpVisitor)this);
        int y = this.stack.size();
        if (x != y) {
            Log.warn((Object)this, (String)"Possible stack misalignment");
        }
        T value = this.pop();
        return value;
    }

    public void visit(OpBGP opBGP) {
        T input = this.pop();
        T value = this.evaluator.eval(opBGP, input);
        this.push(value);
    }

    public void visit(OpQuadPattern quadPattern) {
        T input = this.pop();
        T value = this.evaluator.eval(quadPattern, input);
        this.push(value);
    }

    public void visit(OpQuadBlock quadBlock) {
        T input = this.pop();
        T value = this.evaluator.eval(quadBlock, input);
        this.push(value);
    }

    public void visit(OpTriple opTriple) {
        T input = this.pop();
        T value = this.evaluator.eval(opTriple, input);
        this.push(value);
    }

    public void visit(OpQuad opQuad) {
        T input = this.pop();
        T value = this.evaluator.eval(opQuad, input);
        this.push(value);
    }

    public void visit(OpPath opPath) {
        T input = this.pop();
        T value = this.evaluator.eval(opPath, input);
        this.push(value);
    }

    public void visit(OpProcedure opProc) {
        T input = this.pop();
        T value = this.evaluator.eval(opProc, input);
        this.push(value);
    }

    public void visit(OpPropFunc opPropFunc) {
        T input = this.pop();
        T value = this.evaluator.eval(opPropFunc, input);
        this.push(value);
    }

    public void visit(OpJoin opJoin) {
        T input = this.pop();
        T value = this.evaluator.eval(opJoin, input);
        this.push(value);
    }

    public void visit(OpSequence opSequence) {
        T input = this.pop();
        T value = this.evaluator.eval(opSequence, input);
        this.push(value);
    }

    public void visit(OpDisjunction opDisjunction) {
        T input = this.pop();
        T value = this.evaluator.eval(opDisjunction, input);
        this.push(value);
    }

    public void visit(OpLeftJoin opLeftJoin) {
        T input = this.pop();
        T value = this.evaluator.eval(opLeftJoin, input);
        this.push(value);
    }

    public void visit(OpSemiJoin opSemiJoin) {
        T input = this.pop();
        T value = this.evaluator.eval(opSemiJoin, input);
        this.push(value);
    }

    public void visit(OpAntiJoin opAntiJoin) {
        T input = this.pop();
        T value = this.evaluator.eval(opAntiJoin, input);
        this.push(value);
    }

    public void visit(OpMinus opMinus) {
        T input = this.pop();
        T value = this.evaluator.eval(opMinus, input);
        this.push(value);
    }

    public void visit(OpUnion opUnion) {
        T input = this.pop();
        T value = this.evaluator.eval(opUnion, input);
        this.push(value);
    }

    public void visit(OpLateral opLateral) {
        T input = this.pop();
        T value = this.evaluator.eval(opLateral, input);
        this.push(value);
    }

    public void visit(OpConditional opCondition) {
        T input = this.pop();
        T value = this.evaluator.eval(opCondition, input);
        this.push(value);
    }

    public void visit(OpFilter opFilter) {
        T input = this.pop();
        T value = this.evaluator.eval(opFilter, input);
        this.push(value);
    }

    public void visit(OpGraph opGraph) {
        T input = this.pop();
        T value = this.evaluator.eval(opGraph, input);
        this.push(value);
    }

    public void visit(OpService opService) {
        T input = this.pop();
        T value = this.evaluator.eval(opService, input);
        this.push(value);
    }

    public void visit(OpDatasetNames dsNames) {
        T input = this.pop();
        T value = this.evaluator.eval(dsNames, input);
        this.push(value);
    }

    public void visit(OpTable opTable) {
        T input = this.pop();
        T value = this.evaluator.eval(opTable, input);
        this.push(value);
    }

    public void visit(OpExt opExt) {
        T input = this.pop();
        T value = this.evaluator.eval(opExt, input);
        this.push(value);
    }

    public void visit(OpNull opNull) {
        T input = this.pop();
        T value = this.evaluator.eval(opNull, input);
        this.push(value);
    }

    public void visit(OpLabel opLabel) {
        T input = this.pop();
        T value = this.evaluator.eval(opLabel, input);
        this.push(value);
    }

    public void visit(OpList opList) {
        T input = this.pop();
        T value = this.evaluator.eval(opList, input);
        this.push(value);
    }

    public void visit(OpOrder opOrder) {
        T input = this.pop();
        T value = this.evaluator.eval(opOrder, input);
        this.push(value);
    }

    public void visit(OpProject opProject) {
        T input = this.pop();
        T value = this.evaluator.eval(opProject, input);
        this.push(value);
    }

    public void visit(OpDistinct opDistinct) {
        T input = this.pop();
        T value = this.evaluator.eval(opDistinct, input);
        this.push(value);
    }

    public void visit(OpReduced opReduced) {
        T input = this.pop();
        T value = this.evaluator.eval(opReduced, input);
        this.push(value);
    }

    public void visit(OpAssign opAssign) {
        T input = this.pop();
        T value = this.evaluator.eval(opAssign, input);
        this.push(value);
    }

    public void visit(OpExtend opExtend) {
        T input = this.pop();
        T value = this.evaluator.eval(opExtend, input);
        this.push(value);
    }

    public void visit(OpSlice opSlice) {
        T input = this.pop();
        T value = this.evaluator.eval(opSlice, input);
        this.push(value);
    }

    public void visit(OpGroup opGroup) {
        T input = this.pop();
        T value = this.evaluator.eval(opGroup, input);
        this.push(value);
    }

    public void visit(OpTopN opTop) {
        T input = this.pop();
        T value = this.evaluator.eval(opTop, input);
        this.push(value);
    }

    private void push(T value) {
        this.stack.push(value);
    }

    private T pop() {
        if (this.stack.size() == 0) {
            Log.warn((Object)this, (String)"Warning: pop: empty stack");
        }
        return this.stack.pop();
    }

    public void visit(OpUnfold opUnfold) {
        T input = this.pop();
        T value = this.evaluator.eval(opUnfold, input);
        this.push(value);
    }
}

