/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.collections.generator.GeneratorBlacklist;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;

public class TransformUnionQuery2
extends TransformCopy {
    protected Deque<Node> currentGraph = new ArrayDeque<Node>();
    protected Generator<Var> varGen;

    public TransformUnionQuery2(Generator<Var> varGen) {
        this.currentGraph.push(Quad.defaultGraphNodeGenerated);
        this.varGen = varGen;
    }

    public static Op transform(Op op) {
        Collection blacklist = OpVars.mentionedVars((Op)op);
        GeneratorBlacklist varGen = GeneratorBlacklist.create((Generator)VarGeneratorImpl2.create(), (Collection)blacklist);
        TransformUnionQuery2 t = new TransformUnionQuery2((Generator<Var>)varGen);
        Op op2 = Transformer.transform((Transform)t, (Op)op, (OpVisitor)new Pusher(t.currentGraph), (OpVisitor)new Popper(t.currentGraph));
        return op2;
    }

    public Op transform(OpQuadPattern quadPattern) {
        Op result;
        if (quadPattern.isDefaultGraph() || quadPattern.isUnionGraph()) {
            OpBGP opBGP = new OpBGP(quadPattern.getBasicPattern());
            result = this.union(opBGP);
        } else {
            result = super.transform(quadPattern);
        }
        return result;
    }

    public Op transform(OpBGP opBGP) {
        Node current = this.currentGraph.peek();
        Op result = current == Quad.defaultGraphNodeGenerated || current == Quad.unionGraph ? this.union(opBGP) : super.transform(opBGP);
        return result;
    }

    public Op transform(OpGraph opGraph, Op x) {
        return super.transform(opGraph, x);
    }

    protected Op union(OpBGP opBGP) {
        List ops = opBGP.getPattern().getList().stream().map(t -> {
            BasicPattern bp = new BasicPattern();
            bp.add(t);
            return new OpQuadPattern((Node)this.varGen.next(), bp);
        }).collect(Collectors.toList());
        OpN result = ops.size() == 1 ? (Op)ops.get(0) : OpSequence.create().copy(ops);
        return result;
    }

    static class Pusher
    extends OpVisitorBase {
        private Deque<Node> stack;

        Pusher(Deque<Node> stack) {
            this.stack = stack;
        }

        public void visit(OpGraph opGraph) {
            this.stack.push(opGraph.getNode());
        }
    }

    static class Popper
    extends OpVisitorBase {
        private Deque<Node> stack;

        Popper(Deque<Node> stack) {
            this.stack = stack;
        }

        public void visit(OpGraph opGraph) {
            Node n = this.stack.pop();
            if (!opGraph.getNode().equals((Object)n)) {
                throw new ARQInternalErrorException();
            }
        }
    }
}

