/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.List;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.core.VarExprList;

public class TransformPushSlice
extends TransformCopy {
    public static final TransformPushSlice fn = new TransformPushSlice();

    public Op transform(OpSlice opSlice, Op subOp) {
        Op result = null;
        List<Op> subSubOps = OpUtils.getSubOps(subOp);
        if (subSubOps.size() == 1) {
            Op subSubOp = subSubOps.iterator().next();
            OpSlice replacement = new OpSlice(subSubOp, opSlice.getStart(), opSlice.getLength());
            if (subOp instanceof OpService) {
                OpService x = (OpService)subOp;
                result = new OpService(x.getService(), (Op)replacement, x.getServiceElement(), x.getSilent());
            } else if (subOp instanceof OpProject) {
                OpProject x = (OpProject)subOp;
                result = new OpProject((Op)replacement, x.getVars());
            } else if (subOp instanceof OpExtend) {
                OpExtend x = (OpExtend)subOp;
                result = OpExtend.create((Op)replacement, (VarExprList)x.getVarExprList());
            } else if (subOp instanceof OpSlice) {
                OpSlice x = (OpSlice)subOp;
                Range outer = QueryUtils.toRange((OpSlice)x);
                Range inner = QueryUtils.toRange((OpSlice)opSlice);
                Range combined = RangeUtils.makeAbsolute((Range)outer, (Range)inner, (DiscreteDomain)DiscreteDomain.longs(), (a, b) -> a + b);
                result = QueryUtils.applyRange((Op)x.getSubOp(), (Range)combined);
            }
        }
        if (result == null) {
            result = super.transform(opSlice, subOp);
        }
        return result;
    }
}

