/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.optimize.TransformPromoteTableEmpty;
import org.apache.jena.sparql.algebra.table.TableUnit;

public class TransformPromoteTableEmptyVarPreserving
extends TransformPromoteTableEmpty {
    public static Op transform(Op op) {
        TransformPromoteTableEmptyVarPreserving transform = new TransformPromoteTableEmptyVarPreserving();
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(subOp)) {
            return subOp;
        }
        return super.transform(opFilter, subOp);
    }

    public Op transform(OpJoin opJoin, Op left, Op right) {
        if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(left) || TransformPromoteTableEmptyVarPreserving.isTableEmpty(right)) {
            return OpUtils.createEmptyTableUnionVars(left, right);
        }
        return super.transform(opJoin, left, right);
    }

    public Op transform(OpLeftJoin opLeftJoin, Op left, Op right) {
        if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(left)) {
            return OpUtils.createEmptyTableUnionVars(left, right);
        }
        if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(right)) {
            return OpUtils.createEmptyTableUnionVars(left, right);
        }
        return super.transform(opLeftJoin, left, right);
    }

    public Op transform(OpMinus opMinus, Op left, Op right) {
        if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(left)) {
            return left;
        }
        if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(right)) {
            return left;
        }
        return super.transform(opMinus, left, right);
    }

    public Op transform(OpUnion opUnion, Op left, Op right) {
        if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(left)) {
            if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(right)) {
                return OpUtils.createEmptyTableUnionVars(left, right);
            }
            return right;
        }
        if (TransformPromoteTableEmptyVarPreserving.isTableEmpty(right)) {
            return left;
        }
        return super.transform(opUnion, left, right);
    }

    public static boolean isTableEmpty(Op op) {
        boolean result;
        if (op instanceof OpTable) {
            Table table = ((OpTable)op).getTable();
            result = table.isEmpty();
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isTableUnit(Op op) {
        boolean result;
        if (op instanceof OpTable) {
            Table table = ((OpTable)op).getTable();
            result = table instanceof TableUnit;
        } else {
            result = false;
        }
        return result;
    }
}

