/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.Arrays;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.Expr;

public class TransformOpDatasetNamesToOpGraph
extends TransformCopy {
    public Op transform(OpGraph op, Op subOp) {
        boolean isNoPattern = OpUtils.isNoPattern(subOp);
        Op result = isNoPattern ? TransformOpDatasetNamesToOpGraph.transform(op.getNode()) : super.transform(op, subOp);
        return result;
    }

    public Op transform(OpDatasetNames op) {
        return TransformOpDatasetNamesToOpGraph.transform(op.getGraphNode());
    }

    public static Op transform(Node node) {
        Op result;
        if (node.isVariable() || node.isBlank()) {
            Var var = (Var)node;
            String prefix = "__" + (node.isVariable() ? node.getName() : node.getBlankNodeLabel()) + "_";
            BasicPattern bgp = new BasicPattern();
            bgp.add(Triple.create((Node)Var.alloc((String)(prefix + "s")), (Node)Var.alloc((String)(prefix + "p")), (Node)Var.alloc((String)(prefix + "o"))));
            result = new OpDistinct((Op)new OpProject((Op)new OpGraph(node, (Op)new OpBGP(bgp)), Arrays.asList(var)));
        } else {
            String prefix = "__g_";
            BasicPattern bgp = new BasicPattern();
            bgp.add(Triple.create((Node)Var.alloc((String)(prefix + "s")), (Node)Var.alloc((String)(prefix + "p")), (Node)Var.alloc((String)(prefix + "o"))));
            result = OpFilter.filter((Expr)new E_Exists((Op)new OpGraph(node, (Op)new OpBGP(bgp))), (Op)OpTable.unit());
        }
        return result;
    }
}

