/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformExistsToOptional
extends TransformCopy {
    protected Generator<Var> varGen;

    public static TransformExistsToOptional create(Op inputOp) {
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create((String)"__exists", (Collection)OpVars.mentionedVars((Op)inputOp));
        return new TransformExistsToOptional((Generator<Var>)varGen);
    }

    public TransformExistsToOptional() {
        this((Generator<Var>)VarGeneratorImpl2.create((String)"__exists"));
    }

    public TransformExistsToOptional(Generator<Var> varGen) {
        this.varGen = varGen;
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        Op result;
        ExprList newExprs;
        ExprTransformExistsToOptional exprTransform = new ExprTransformExistsToOptional(subOp);
        ExprList oldExprs = opFilter.getExprs();
        if (!oldExprs.equals((Object)(newExprs = ExprTransformer.transform((ExprTransform)exprTransform, (ExprList)oldExprs)))) {
            Op lhs = exprTransform.getCurrentLhs();
            result = OpFilter.filterBy((ExprList)newExprs, (Op)lhs);
            result = new OpProject(result, new ArrayList<Var>(exprTransform.getInitialLhsVisibleVars()));
        } else {
            result = super.transform(opFilter, subOp);
        }
        return result;
    }

    public static void main(String[] args) {
        String str = "SELECT * {\n  ?s ?p ?o\n  FILTER EXISTS { ?s <urn:label> ?l }\n  FILTER NOT EXISTS { ?s <urn:knows> ?l }\n}\n";
        Op beforeOp = Algebra.compile((Query)QueryFactory.create((String)str));
        Op afterOp = Transformer.transform((Transform)TransformExistsToOptional.create(beforeOp), (Op)beforeOp);
        Query afterQuery = OpAsQuery.asQuery((Op)afterOp);
        System.out.println(afterQuery);
    }

    public class ExprTransformExistsToOptional
    extends ExprTransformCopy {
        protected Op lhs;
        protected Set<Var> initialLhsVisibleVars;

        public Op getCurrentLhs() {
            return this.lhs;
        }

        public ExprTransformExistsToOptional(Op lhs) {
            this(lhs, OpVars.visibleVars((Op)lhs));
        }

        public ExprTransformExistsToOptional(Op lhs, Set<Var> lhsVisibleVars) {
            this.lhs = lhs;
            this.initialLhsVisibleVars = lhsVisibleVars;
        }

        public Set<Var> getInitialLhsVisibleVars() {
            return this.initialLhsVisibleVars;
        }

        public Expr transform(ExprFunctionOp funcOp, ExprList args, Op rhs) {
            Expr result = null;
            boolean isNotExists = funcOp instanceof E_NotExists;
            boolean isExists = funcOp instanceof E_Exists;
            if (isExists || isNotExists) {
                Op newOp;
                Set joinVarSet = OpVars.visibleVars((Op)rhs);
                joinVarSet.retainAll(this.initialLhsVisibleVars);
                ArrayList<Var> joinVars = new ArrayList<Var>(joinVarSet);
                Var existsVar = (Var)TransformExistsToOptional.this.varGen.next();
                joinVars.add(existsVar);
                Op newRhs = rhs;
                newRhs = OpExtend.extend((Op)newRhs, (Var)existsVar, (Expr)NodeValue.TRUE);
                if (!joinVars.isEmpty()) {
                    newRhs = new OpProject(newRhs, joinVars);
                }
                newRhs = OpDistinct.create((Op)newRhs);
                this.lhs = newOp = OpLeftJoin.create((Op)this.lhs, (Op)newRhs, (Expr)null);
                result = new E_Equals((Expr)new ExprVar(existsVar), (Expr)NodeValue.TRUE);
                if (isNotExists) {
                    result = new E_LogicalNot(result);
                }
            } else {
                result = super.transform(funcOp, args, rhs);
            }
            return result;
        }
    }
}

