/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.QuadPattern;

public class TransformDeduplicatePatterns
extends TransformCopy {
    public static Op transform(Op op) {
        TransformDeduplicatePatterns transform = new TransformDeduplicatePatterns();
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public static BasicPattern deduplicate(BasicPattern pattern) {
        return BasicPattern.wrap(new ArrayList(new LinkedHashSet(pattern.getList())));
    }

    public static PathBlock deduplicate(PathBlock pattern) {
        PathBlock result = new PathBlock();
        new LinkedHashSet(pattern.getList()).forEach(arg_0 -> ((PathBlock)result).add(arg_0));
        return result;
    }

    public static QuadPattern deduplicate(QuadPattern pattern) {
        QuadPattern result = new QuadPattern();
        new LinkedHashSet(pattern.getList()).forEach(arg_0 -> ((QuadPattern)result).add(arg_0));
        return result;
    }

    public Op transform(OpBGP op) {
        BasicPattern before = op.getPattern();
        BasicPattern after = TransformDeduplicatePatterns.deduplicate(before);
        OpBGP result = after.equals((Object)before) ? op : new OpBGP(after);
        return result;
    }

    public Op transform(OpQuadBlock op) {
        QuadPattern before = op.getPattern();
        QuadPattern after = TransformDeduplicatePatterns.deduplicate(before);
        OpQuadBlock result = after.equals((Object)before) ? op : new OpQuadBlock(after);
        return result;
    }

    public Op transform(OpQuadPattern op) {
        BasicPattern before = op.getBasicPattern();
        BasicPattern after = TransformDeduplicatePatterns.deduplicate(before);
        OpQuadPattern result = after.equals((Object)before) ? op : new OpQuadPattern(op.getGraphNode(), after);
        return result;
    }
}

