/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.syntax.VarExprListUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;

public class ProjectExtend {
    protected List<Var> project = null;
    protected VarExprList vel = null;
    protected Op subOp;
    protected Set<Var> pullableVars = new LinkedHashSet<Var>();
    protected Set<Var> nonPullableVars;

    public ProjectExtend(List<Var> project, VarExprList vel, Op subOp) {
        this.project = project;
        this.vel = vel;
        this.subOp = subOp;
        List vars = project != null ? project : vel.getVars();
        for (Var var : vars) {
            Expr expr = vel.getExpr(var);
            if (expr == null || !expr.isConstant()) continue;
            this.pullableVars.add(var);
        }
        this.nonPullableVars = vars.stream().filter(v -> !this.pullableVars.contains(v)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Var> getPullableVars() {
        return this.pullableVars;
    }

    public Set<Var> getNonPullableVars() {
        return this.nonPullableVars;
    }

    public List<Var> getProject() {
        return this.project;
    }

    public VarExprList getVel() {
        return this.vel;
    }

    public Op getSubOp() {
        return this.subOp;
    }

    public Op toOp() {
        return this.apply(this.subOp);
    }

    public Op apply(Op subOp) {
        Op result = subOp;
        if (this.vel != null) {
            result = OpExtend.create((Op)result, (VarExprList)this.vel);
        }
        if (this.project != null) {
            result = new OpProject(result, this.project);
        }
        return result;
    }

    public static Op apply(List<Var> project, VarExprList vel, Op subOp) {
        Op result = subOp;
        if (vel != null) {
            result = OpExtend.create((Op)result, (VarExprList)vel);
        }
        if (project != null) {
            result = new OpProject(result, project);
        }
        return result;
    }

    public static Op applyIfNeeded(boolean project, VarExprList vel, Op subOp) {
        Op result = subOp;
        if (!vel.isEmpty()) {
            VarExprList tmp = VarExprListUtils.projectExprsOnly((VarExprList)vel, (Collection)vel.getVars());
            if (!tmp.isEmpty()) {
                result = OpExtend.create((Op)result, (VarExprList)tmp);
            }
            if (project) {
                result = new OpProject(result, vel.getVars());
            }
        }
        return result;
    }

    public static ProjectExtend collect(Op op) {
        OpProject o;
        List project = null;
        VarExprList vel = null;
        Op tmp = op;
        if (tmp instanceof OpProject) {
            o = (OpProject)tmp;
            project = o.getVars();
            tmp = o.getSubOp();
        }
        if (tmp instanceof OpExtend) {
            o = (OpExtend)tmp;
            vel = o.getVarExprList();
            tmp = o.getSubOp();
        }
        ProjectExtend result = vel == null ? null : new ProjectExtend(project, vel, tmp);
        return result;
    }

    public String toString() {
        String result = String.valueOf(this.apply(this.subOp));
        return result;
    }
}

