/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.expr.transform;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.commons.util.function.FixpointIteration;
import org.aksw.jena_sparql_api.algebra.transform.TransformExprToBasicPattern;
import org.aksw.jena_sparql_api.algebra.transform.TransformPullFiltersIfCanMergeBGPs;
import org.aksw.jena_sparql_api.algebra.transform.TransformReplaceConstants;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.model.udf.util.UserDefinedFunctions;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.optimize.TransformMergeBGPs;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.E_OneOfBase;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprTransformVirtualBnodeUris
extends ExprTransformCopy {
    public static final String ns = "http://ns.aksw.org/function/";
    public static final String bidOfFnIri = "http://ns.aksw.org/function/bidOf";
    public static final String decodeBnodeIriFnIri = "http://ns.aksw.org/function/decodeBnodeIri";
    public static final String isBnodeIriFnIri = "http://ns.aksw.org/function/isBnodeIri";
    public static final String forceBnodeIriFnIri = "http://ns.aksw.org/function/forceBnodeIri";
    protected Map<String, UserDefinedFunctionDefinition> macros;
    protected Map<String, Boolean> propertyFunctions;
    private static final Logger logger = LoggerFactory.getLogger(ExprTransformVirtualBnodeUris.class);

    public ExprTransformVirtualBnodeUris(Map<String, UserDefinedFunctionDefinition> macros, Map<String, Boolean> propertyFunctions) {
        this.macros = macros;
        this.propertyFunctions = propertyFunctions;
    }

    public Expr transform(ExprFunctionN func, ExprList args) {
        Expr result = null;
        if (func instanceof E_OneOfBase) {
            E_OneOfBase e = (E_OneOfBase)func;
            Expr lhs = e.getLHS();
            ExprList rhs = e.getRHS();
            List bnodeConsts = rhs.getList().stream().filter(x -> x.isConstant() && this.isBnodeIri(x.getConstant())).collect(Collectors.toList());
            if (!bnodeConsts.isEmpty()) {
                ArrayList<Object> exprs = new ArrayList<Object>();
                List nonBnodes = rhs.getList().stream().filter(x -> !bnodeConsts.contains(x)).collect(Collectors.toList());
                if (func instanceof E_OneOf) {
                    if (!nonBnodes.isEmpty()) {
                        exprs.add(new E_OneOf(lhs, new ExprList(nonBnodes)));
                    }
                    for (Expr bnodeConst : bnodeConsts) {
                        E_Equals rawEq = new E_Equals(lhs, bnodeConst);
                        Expr eq = this.transform((ExprFunction2)rawEq, rawEq.getArg1(), rawEq.getArg2());
                        exprs.add(eq);
                    }
                    result = org.aksw.jenax.arq.util.expr.ExprUtils.orifyBalanced(exprs);
                } else if (func instanceof E_NotOneOf) {
                    if (!nonBnodes.isEmpty()) {
                        exprs.add(new E_NotOneOf(lhs, new ExprList(nonBnodes)));
                    }
                    for (Expr bnodeConst : bnodeConsts) {
                        E_NotEquals rawEq = new E_NotEquals(lhs, bnodeConst);
                        Expr eq = this.transform((ExprFunction2)rawEq, rawEq.getArg1(), rawEq.getArg2());
                        exprs.add(eq);
                    }
                    result = org.aksw.jenax.arq.util.expr.ExprUtils.andifyBalanced(exprs);
                } else {
                    throw new IllegalStateException("Should never come here");
                }
            }
        }
        if (result == null) {
            result = func.copy(args);
        }
        return result;
    }

    public Expr transform(ExprFunction2 func, Expr a, Expr b) {
        ExprFunction2 result = null;
        if (!a.isConstant() && b.isConstant()) {
            result = this.trySubst(func, a, b, false);
            a = result.getArg1();
            b = result.getArg2();
        }
        if (a.isConstant() && !b.isConstant()) {
            result = this.trySubst(func, b, a, true);
        }
        if (result == null) {
            result = (ExprFunction2)super.transform(func, a, b);
        }
        return result;
    }

    public static <T extends ExprFunction2> T copy(T func, Expr a, Expr b, boolean swapped) {
        ExprFunction2 result = swapped ? (ExprFunction2)func.copy(b, a) : (ExprFunction2)func.copy(a, b);
        return (T)result;
    }

    public static Node bnodeToIri(Node node) {
        Node result = node.isBlank() ? NodeFactory.createURI((String)("bnode://" + node.getBlankNodeLabel())) : node;
        return result;
    }

    public boolean isBnodeIri(NodeValue in) {
        NodeValue out = UserDefinedFunctions.eval(this.macros, (String)isBnodeIriFnIri, (Expr[])new Expr[]{in});
        boolean result = out.getBoolean();
        return result;
    }

    public NodeValue decodeBnodeIriFn(NodeValue in) {
        NodeValue bnodeLabel;
        try {
            bnodeLabel = UserDefinedFunctions.eval(this.macros, (String)decodeBnodeIriFnIri, (Expr[])new Expr[]{in});
        }
        catch (ExprEvalException e) {
            bnodeLabel = NodeValue.FALSE;
        }
        return bnodeLabel;
    }

    public ExprFunction2 trySubst(ExprFunction2 func, Expr lhs, Expr b, boolean swapped) {
        ExprFunction2 result;
        NodeValue rhs = b.getConstant();
        boolean isRhsBnodeUri = this.isBnodeIri(rhs);
        if (isRhsBnodeUri) {
            NodeValue bnodeLabel = this.decodeBnodeIriFn(rhs);
            Expr x = this.macros.get(bidOfFnIri).getBaseExpr();
            Expr labelCondition = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(Vars.x, lhs), (Expr)x);
            result = ExprTransformVirtualBnodeUris.copy(func, labelCondition, (Expr)bnodeLabel, swapped);
        } else {
            result = ExprTransformVirtualBnodeUris.copy(func, lhs, b, swapped);
        }
        return result;
    }

    public Query rewrite(Query query) {
        Query result = QueryUtils.rewrite((Query)query, op -> {
            Op a = TransformReplaceConstants.transform(op, x -> x.isURI() ? UserDefinedFunctions.eval(this.macros, (String)isBnodeIriFnIri, (Expr[])new Expr[]{NodeValue.makeNode((Node)x)}).getBoolean() : false);
            Op b = Transformer.transform(null, (ExprTransform)this, (Op)a);
            Op c = this.forceBnodeUris(b);
            Op d = TransformExprToBasicPattern.transform(c, fn -> {
                String id = org.aksw.jenax.arq.util.expr.ExprUtils.getFunctionId((ExprFunction)fn.getFunction());
                Boolean subjectAsOutput = this.propertyFunctions.get(id);
                Map.Entry r = subjectAsOutput == null ? null : Maps.immutableEntry((Object)id, (Object)subjectAsOutput);
                return r;
            });
            Op e = (Op)FixpointIteration.apply((Object)d, x -> {
                x = TransformPullFiltersIfCanMergeBGPs.transform(x);
                x = Transformer.transform((Transform)new TransformMergeBGPs(), (Op)x);
                return x;
            });
            return e;
        });
        if (logger.isDebugEnabled()) {
            logger.debug("Rewrote query\n" + String.valueOf(query) + " to\n" + String.valueOf(result));
        }
        return result;
    }

    public static ExprTransformVirtualBnodeUris createTransformFromUdfModel(Model model, Collection<String> activeProfiles) {
        HashSet<String> profiles = new HashSet<String>(activeProfiles);
        Map map = UserDefinedFunctions.load((Model)model, profiles);
        Map<String, Boolean> propertyFunctions = Collections.singletonMap("http://www.ontotext.com/owlim/entity#id", false);
        ExprTransformVirtualBnodeUris result = new ExprTransformVirtualBnodeUris(map, propertyFunctions);
        return result;
    }

    public Op forceBnodeUris(Op op) {
        ArrayList visibleVars = new ArrayList(OpVars.visibleVars((Op)op));
        HashSet forbiddenVars = new HashSet(OpVars.mentionedVars((Op)op));
        Map<Var, Var> map = visibleVars.stream().collect(Collectors.toMap(v -> v, v -> VarGeneratorBlacklist.create((String)v.getName(), (Collection)forbiddenVars).next()));
        Op tmp = NodeTransformLib.transform(n -> n.isVariable() ? (Node)map.getOrDefault(n, (Var)n) : n, (Op)op);
        VarExprList vel = new VarExprList();
        for (Var v2 : visibleVars) {
            vel.add(v2, UserDefinedFunctions.expandMacro(this.macros, (String)forceBnodeIriFnIri, (Expr[])new Expr[]{new ExprVar(map.get(v2))}));
        }
        OpProject result = new OpProject((Op)OpExtend.create((Op)tmp, (VarExprList)vel), visibleVars);
        return result;
    }

    public static void main(String[] args) {
        Expr input = ExprUtils.parse((String)"?x NOT IN (<bnode://123>, <urn:foo>, <bnode://456>, <urn:bar>)");
        Model model = RDFDataMgr.loadModel((String)"bnode-rewrites.ttl");
        SparqlStmtMgr.execSparql((Model)model, (String)"udf-inferences.rq");
        HashSet<String> profiles = new HashSet<String>(Arrays.asList("http://ns.aksw.org/profile/graphdb"));
        ExprTransformVirtualBnodeUris xform = ExprTransformVirtualBnodeUris.createTransformFromUdfModel(model, profiles);
        Expr output = ExprTransformer.transform((ExprTransform)xform, (Expr)input);
        System.out.println(output);
        Query query = QueryFactory.create((String)"CONSTRUCT { ?s ?p ?o } { ?s <bnode://foo> ?t . ?s ?p ?o . FILTER(?p = <bnode://bar>)} ORDER BY ?s");
        Query actual = xform.rewrite(query);
        System.out.println(actual);
    }
}

